const system = require("../../../system");
const Dao = require("../../dao.base");
const url = require("url");
class CompanyDao extends Dao {
    constructor() {
        super(Dao.getModelName(CompanyDao));
    }
    async createOrUpdate(pobj, t) {
        const companyData = await this.findOne({
            enterpriseCode: pobj.enterpriseCode
        });
        let result = {};
        if (companyData) {
            //更新
            delete pobj.firstBuyTime
            await this.updateByWhere(pobj, {
                enterpriseCode: pobj.enterpriseCode
            }, t);
            result = { id: companyData.id }
        } else {
            // 创建
            let data = await this.create(pobj, t);
            result = { id: data.id };
        }
        return result
    }

}
module.exports = CompanyDao;
