const system = require("../../../system");
const Dao = require("../../dao.base");
const url = require("url");
class QualificationDao extends Dao {
    constructor() {
        super(Dao.getModelName(QualificationDao));
    }
    async createOrUpdate(pobj, t) {
        const qualificationData = await this.findOne({
            deliver_id: pobj.deliver_id
        });
        let result = {};
        let info = {
            businessScope: pobj.businessScope,
            businessTypes: pobj.businessTypes,
            certificateNumber: pobj.certificateNumber,
            endAt: pobj.endAt,
            file: pobj.file,
            serviceProject: pobj.serviceProject,
            startAt: pobj.startAt,
            deliver_id: pobj.deliver_id
        }
        if (qualificationData) {
            //更新
            await this.updateByWhere(info, {
                deliver_id: pobj.deliver_id
            }, t);
            result = { id: qualificationData.id }
        } else {
            // 创建
            let data = await this.create(info, t);
            result = { id: data.id };
        }
        return result
    }
}
module.exports = QualificationDao;
