const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const moment = require("moment");
const uuidv4 = require('uuid/v4');
const _ = require("lodash")
const pushQft = require("../../../utils/toqifutongClient")
class BizbatchService extends ServiceBase {
    constructor() {
        super("bizchance", ServiceBase.getDaoName(BizbatchService));
        this.bizoptDao = system.getObject("db.bizchance.bizoptDao");
    }
    async create(pobj) {
        let batchInfo = pobj.batchArray.map(item => {
            item.uniqueCode = uuidv4()
            return item;
        })
        let data = {
            batchNumber: new Date().getTime(),
            batchInfo,
            processingStatus: 'processing',
            createrId: pobj.userid,
            createrName: pobj.username,
            createrOpcode: pobj.opath
        }
        await pushQft.batchCreateBiz({
            batchNumber: data.batchNumber,
            demands: batchInfo
        });
        let result = await this.dao.create(data);
        return result;
    }

    async findAndCountAll(pobj) {
        let result = await this.dao.findAndCountAll(pobj);
        if (result.results.count > 0) {
            let rows = [];
            let demandCodes = []
            for (let val of result.results.rows) {
                rows.push({
                    id: val.id,
                    batchNumber: val.batchNumber,
                    processingStatus: val.processingStatus,
                    payStatus: "waitPay",
                    paymentLink: val.paymentLink,
                    createrName: val.createrName,
                    createrId: val.createrId,
                    created_at: moment(val.created_at).format('YYYY-MM-DD HH:mm:ss'),
                    updated_at: moment(val.updated_at).format('YYYY-MM-DD HH:mm:ss'),
                    demandCodeSum: val.batchInfo.length,
                    demandCodes: val.batchInfo.filter(item => item.demandCode).map(item => {
                        return item.demandCode
                    })
                })
                if (val.processingStatus === "success") {
                    demandCodes.push(...val.batchInfo.map(item => {
                        return item.demandCode
                    }));
                }
            }
            let demandData = await this.bizoptDao.findAll({
                demand_code: {
                    $in: demandCodes,
                },
                business_status: system.BUSSTATUS.SUCCESS
            });
            demandCodes = demandData.map(item => item.demand_code);
            for (let val of rows) {
                if (val.processingStatus === "success") {
                    val.payStatus = _.intersection(val.demandCodes, demandCodes).length > 0 ? "successPay" : val.payStatus;
                }
            }
            result.results.rows = rows;
        }
        return result;
    }

    async detail(pobj) {
        let bizbatchData = await this.dao.findOne({
            id: pobj.id
        });
        if (!bizbatchData) {
            return []
        } else {
            let demandCodes = bizbatchData.batchInfo.filter(item => item.demandCode).map(item => {
                return item.demandCode
            });
            let bizoptData = await this.bizoptDao.findAll({
                demand_code: {
                    $in: demandCodes
                }
            });
            return bizoptData.map(item => {
                return {
                    id: item.id,
                    demand_code: item.demand_code,
                    business_type: item.business_type,
                    customer_name: item.business_info.contactsName,
                    customer_number: item.business_info.contactsPhone,
                    service_name: item.business_info.serviceName,
                    business_status: item.business_status,
                    memo_info: item.business_info.memoInfo,
                    created_at: moment(item.created_at).format('YYYY-MM-DD HH:mm:ss'),
                }
            })
        }
    }
}
module.exports = BizbatchService;
