const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const moment = require("moment");
const pushQft = require("../../../utils/toqifutongClient")
const TOQFT = require("../../../utils/toQft");


class CompanycaseService extends ServiceBase {
    constructor() {
        super("delivery", ServiceBase.getDaoName(CompanycaseService));
        this.cacheinfoDao = system.getObject("db.delivery.cacheinfoDao");
        this.deliveryDao = system.getObject("db.delivery.deliverDao");
        this.newmaterialDao = system.getObject("db.delivery.newmaterialDao");
        this.statuslogDao = system.getObject("db.bizchance.statuslogDao");
        this.qualificationDao = system.getObject("db.delivery.qualificationDao");
    }

    async submitMaterials(pobj, qobj, req) {
        const deliverData = await this.deliveryDao.findOne({
            id: pobj.deliver_id
        });
        if (!deliverData) {
            throw new Error("查不到此交付单");
        }
        await TOQFT.getClientByType(deliverData.product_code).submitMaterials(pobj.username, deliverData, pobj.cache_info);
        return this.db.transaction(async (t) => {
            await this.cacheinfoDao.createOrUpdate(pobj, t);
            await this.newmaterialDao.createOrUpdate(pobj, t);
            if ([system.SERVERSESTATUS.COLLECTING].includes(deliverData.delivery_status)) {
                let status = system.SERVERSESTATUS.AUDITING;
                await this.deliveryDao.updateByWhere({
                    delivery_status: status
                }, {
                    id: pobj.deliver_id
                }, t);
                this.statuslogDao.create({
                    flow_type: system.FLOWCODE.DELIVERY,
                    flow_id: pobj.deliver_id,
                    status_code: status,
                    salesman_id: pobj.userid,
                    salesman_name: pobj.username
                });
            }
            // 更新公司名称
            if (pobj && pobj.cache_info && pobj.cache_info.companyInfo && pobj.cache_info.companyInfo.companyName) {
                await this.deliveryDao.updateByWhere({
                    company_name: pobj.cache_info.companyInfo.companyName,
                    delivery_info: {
                        ...deliverData.delivery_info,
                        companyName: pobj.cache_info.companyInfo.companyName
                    }
                }, {
                    delivery_code: deliverData.delivery_code
                }, t);
            }
            return "SUCCESS"
        });
    }

    async companyCaseDeliverCommonSubmitMaterials(pobj, qobj, req) {
        const deliverData = await this.deliveryDao.findOne({
            id: pobj.deliver_id
        });
        if (!deliverData) {
            throw new Error("查不到此交付单");
        }
        await this.newmaterialDao.createOrUpdate(pobj);
        return "SUCCESS"
    }

    async changeDeliveryStatus(pobj, qobj, req) {
        const deliverData = await this.deliveryDao.findOne({
            id: pobj.id
        });
        if (!deliverData) {
            throw new Error("没有此交付单");
        }
        let updateData = {};
        let status;
        let materials = {};
        switch (deliverData.delivery_status) {
            case system.SERVERSESTATUS.RECEIVED:
                switch (deliverData.product_code) {
                    case system.SERVICECODE.COMPANYCASE:
                    case system.SERVICECODE.REGADDRCASE1:
                        status = system.SERVERSESTATUS.COLLECTING;
                        break
                    case system.SERVICECODE.TAXCASE:
                    case system.SERVICECODE.OPENBANKACCOUNTCASE:
                        status = system.SERVERSESTATUS.SUCCESS;
                        break
                    case system.SERVICECODE.AGENTCASE1:
                        status = system.SERVERSESTATUS.SERVICEING;
                        break
                    default:
                        throw new Error("异常操作");
                }
                break
            case system.SERVERSESTATUS.COLLECTING: //  收集材料
                const materialData = await this.newmaterialDao.findOne({
                    deliver_id: deliverData.id
                })
                if (materialData && materialData.materialInfo && materialData.materialInfo.file && materialData.materialInfo.file.url) {
                    materials = {
                        deliverContent: {
                            deliverMaterialUrl: materialData.materialInfo.file.url
                        }
                    }
                }
                status = system.SERVERSESTATUS.SERVICEING;
                break
            case system.SERVERSESTATUS.AUDITING: // 工商审核环节
                status = system.SERVERSESTATUS.ENGRAVING;
                break
            case system.SERVERSESTATUS.ENGRAVING: // 刻章环节
                status = system.SERVERSESTATUS.SUCCESS;
                break
            case system.SERVERSESTATUS.SERVICEING: // 服务中
                status = system.SERVERSESTATUS.SUCCESS;
                break
            default:
                throw new Error("此状态手动不能更改");
        }
        if (
            (system.SERVICECODE.REGADDRCASE1 === deliverData.product_code &&
                deliverData.delivery_status === system.SERVERSESTATUS.SERVICEING) ||
            (system.SERVICECODE.AGENTCASE1 === deliverData.product_code &&
                deliverData.delivery_status === system.SERVERSESTATUS.RECEIVED)
        ) {
            if (!pobj.startTime) {
                throw new Error("请传入 服务的起止时间")
            } else {
                const delivery_info = {
                    ...deliverData.delivery_info,
                    startTime: system.SERVICECODE.REGADDRCASE1 === deliverData.product_code
                        ? moment(pobj.startTime).startOf("day").format('YYYY-MM-DD HH:mm:ss')
                        : moment(pobj.startTime).startOf("month").format('YYYY-MM-DD HH:mm:ss'),
                    endTime: system.SERVICECODE.REGADDRCASE1 === deliverData.product_code
                        ? moment(pobj.startTime).add(12, 'month').add(-1, 'day').endOf("day").format('YYYY-MM-DD HH:mm:ss')
                        : moment(pobj.startTime).add(11, 'month').endOf("month").format('YYYY-MM-DD HH:mm:ss'),
                }
                updateData = {
                    delivery_status: status,
                    delivery_info
                }
                deliverData.delivery_info = delivery_info;
            }
        } else {
            updateData = {
                delivery_status: status
            }
        }
        await TOQFT.getClientByType(deliverData.product_code).changeStatus(pobj.username, deliverData, materials);

        await this.deliveryDao.updateByWhere(updateData, {
            id: pobj.id
        })
        this.statuslogDao.create({
            flow_type: system.FLOWCODE.DELIVERY,
            flow_id: pobj.id,
            status_code: status,
            salesman_id: pobj.userid,
            salesman_name: pobj.username
        });
        return "SUCCESS"
    }


    async companyCaseDeliverCommonSubmitQualification(pobj, qobj, req) {
        const deliverData = await this.deliveryDao.findOne({
            id: pobj.deliver_id
        });
        if (!deliverData) {
            throw new Error("查不到此交付单");
        }
        await this.qualificationDao.createOrUpdate(pobj);
        return "SUCCESS"
    }
}
module.exports = CompanycaseService;
