var fs = require("fs");
var objsettings = require("../config/objsettings");
var settings = require("../config/settings");
const request = require('request');
class System {
	static declare(ns) {
		var ar = ns.split('.');
		var root = System;
		for (var i = 0, len = ar.length; i < len; ++i) {
			var n = ar[i];
			if (!root[n]) {
				root[n] = {};
				root = root[n];
			} else {
				root = root[n];
			}
		}
	}
	static async delReq(url, qdata) {
		let rtn = {}
		let promise = new Promise(function (resv, rej) {
			request.del({
				url: url,
				qs: qdata
			}, function (error, response, body) {
				if (!error) {
					rtn.statusCode = response.statusCode
					if (body) {
						let data = JSON.parse(body)
						rtn.data = data
					} else {
						rtn.data = null
					}
					resv(rtn);
				} else {
					rej(error)
				}
			});
		})
		return promise;
	}
	static async getReq(url, qdata) {
		let rtn = {}
		let promise = new Promise(function (resv, rej) {
			request.get({
				url: url,
				json: true,
				qs: qdata
			}, function (error, response, body) {
				if (!error) {
					rtn.statusCode = response.statusCode;
					if (body) {
						rtn.data = body
					} else {
						rtn.data = null
					}
					resv(rtn);
				} else {
					rej(error);
				}
			});
		})
		return promise;
	}
	static async postJsonTypeReq(url, data, md = "POST") {
		let rtn = {}
		let promise = new Promise(function (resv, rej) {
			request({
				url: url,
				method: md,
				json: true,
				headers: {
					'Content-type': 'application/json',
					// 'Authorization': 'Basic YWRtaW5lczphZG1pbkdTQmVzLg=='
				},
				body: data
			}, function (error, response, body) {
				if (!error) {
					rtn.statusCode = response.statusCode
					if (body) {
						rtn.data = body
					} else {
						rtn.data = null
					}
					resv(rtn);
				} else {
					rej(error)
				}
			});
		})
		return promise;
	}
	static async post3wFormTypeReq(url, data) {
		let rtn = {}
		let promise = new Promise(function (resv, rej) {
			request.post({
				url: url,
				form: data
			}, function (error, response, body) {
				if (!error) {
					rtn.statusCode = response.statusCode
					let data = JSON.parse(body)
					rtn.data = data
					resv(rtn);
				} else {
					rej(error)
				}
			});
		})
		return promise;
	}
	static async postMpFormTypeReq(url, formdata) {
		let promise = new Promise(function (resv, rej) {
			request.post({
				url: url,
				formData: formdata
			}, function (error, response, body) {
				if (!error && response.statusCode == 200) {
					resv(body);
				} else {
					rej(error)
				}
			});
		})
		return promise;
	}

	/**
	 * 请求返回成功
	 * @param {*} data 操作成功返回的数据,有值为成功，无值为失败
	 * @param {*} okmsg 操作成功的描述
	 * @param {*} req 请求头信息
	 */
	static getResult(data, opmsg = "操作成功", req) {
		return {
			status: !data ? -1 : 0,
			msg: opmsg,
			data: data,
			bizmsg: req && req.session && req.session.bizmsg ? req.session.bizmsg : "empty"
		};
	}
	/**
	 * 请求返回成功
	 * @param {*} data 操作成功返回的数据
	 * @param {*} okmsg 操作成功的描述
	 */
	static getResultSuccess(data, okmsg = "success") {
		return {
			status: 0,
			msg: okmsg,
			data: data,
		};
	}
	/**
	 * 请求返回失败
	 * @param {*} status 操作失败状态，默认为-1
	 * @param {*} errmsg 操作失败的描述，默认为fail
	 * @param {*} data 操作失败返回的数据
	 */
	static getResultFail(status = -1, errmsg = "fail", data = null) {
		return {
			status: status,
			msg: errmsg,
			data: data,
		};
	}
	/**
	 * 请求处理异常
	 * @param {*} errmsg 操作失败的描述，默认为fail
	 * @param {*} data 操作失败返回的数据
	 */
	static getResultError(errmsg = "fail", data = null) {
		return {
			status: -200,
			msg: errmsg,
			data: data,
		};
	}
	static register(key, ClassObj, groupName, filename) {
		if (System.objTable[key] != null) {
			throw new Error("相同key的对象已经存在");
		} else {
			let obj;
			if (ClassObj.name === "ServiceBase") {
				obj = new ClassObj(groupName, filename.replace("Sve", "Dao"));
			} else {
				obj = new ClassObj(groupName, filename);
			}
			System.objTable[key] = obj;
		}

		return System.objTable[key];
	}
	static getObject(objpath) {
		var pathArray = objpath.split(".");
		var packageName = pathArray[0];
		var groupName = pathArray[1];
		var filename = pathArray[2];
		var classpath = "";
		if (filename) {
			classpath = objsettings[packageName] + "/" + groupName;
		} else {
			classpath = objsettings[packageName];
			filename = groupName;
		}

		var objabspath = classpath + "/" + filename + ".js";

		//判断文件的存在性
		//如果不存在，需要查看packageName
		//如果packageName=web.service,dao

		if (System.objTable[objabspath] != null) {
			return System.objTable[objabspath];
		} else {
			var ClassObj = null;
			try {
				ClassObj = require(objabspath);
			} catch (e) {
				// console.log(e)

				let fname = objsettings[packageName + "base"];
				ClassObj = require(fname);
			}
			if (ClassObj.name == "Dao") {
				let modelname = filename.substring(0, filename.lastIndexOf("Dao"))
				return System.register(objabspath, ClassObj, modelname);
			}
			if (ClassObj.name.indexOf("Ctl") >= 0) {
				console.log(ClassObj.name);
			}
			return System.register(objabspath, ClassObj, groupName, filename);
		}
	}

	static getSysConfig() {
		var configPath = settings.basepath + "/app/base/db/metadata/index.js";
		// if(settings.env=="dev"){
		// 	console.log("delete "+configPath+"cache config");
		// 	delete require.cache[configPath];
		// }
		delete require.cache[configPath];
		var configValue = require(configPath);
		return configValue.config;
	}
	static get_client_ip(req) {
		var ip = req.headers['x-forwarded-for'] ||
			req.ip ||
			req.connection.remoteAddress ||
			req.socket.remoteAddress ||
			(req.connection.socket && req.connection.socket.remoteAddress) || '';
		var x = ip.match(/(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$/);
		if (x) {
			return x[0];
		} else {
			return "localhost";
		}

	};


	/**
	* 记录日志信息
	* @param {*} opTitle 操作的标题
	* @param {*} params 参数
	* @param {*} identifyCode 业务标识
	* @param {*} resultInfo 返回结果
	* @param {*} errorInfo 错误信息
	*/
	static execLogs(opTitle, params, identifyCode, resultInfo, errorInfo) {
		var reqUrl = settings.logUrl();
		let isLogData = true
		if (params.method && (params.method.indexOf("find") >= 0)) {
			isLogData = false
		}
		var param = {
			actionType: "produceLogsData",// Y 功能名称
			actionBody: {
				opTitle: opTitle || "",// N 操作的业务标题                
				identifyCode: identifyCode || "brg-center-manage",// Y 操作的业务标识
				indexName: settings.logindex,// Y es索引值，同一个项目用一个值
				messageBody: params, //日志的描述信息                   
				resultInfo: isLogData ? resultInfo : { status: resultInfo.status },//返回信息
				errorInfo: errorInfo,//错误信息
				requestId: resultInfo.requestId || ""
			}
		};
		let P = new Promise((resv, rej) => {
			this.postJsonTypeReq(reqUrl, param).then(res => {
				if (res.statusCode == 200) {
					resv(res.data)
				} else {
					rej(null)
				}
			});
		})
		return P

	}
}
Date.prototype.Format = function (fmt) { //author: meizz
	var o = {
		"M+": this.getMonth() + 1,                 //月份
		"d+": this.getDate(),                    //日
		"h+": this.getHours(),                   //小时
		"m+": this.getMinutes(),                 //分
		"s+": this.getSeconds(),                 //秒
		"q+": Math.floor((this.getMonth() + 3) / 3), //季度
		"S": this.getMilliseconds()             //毫秒
	};
	if (/(y+)/.test(fmt))
		fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
	for (var k in o)
		if (new RegExp("(" + k + ")").test(fmt))
			fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
	return fmt;
}

/**
 * 常用 ENUM
 */

// 表分类
System.FLOWCODE = {
	BIZ: "BIZ",//商机表
	SCHEME: "SCHEME",//方案表
	DELIVERY: "DELIVERY",//服务单表
	ANNUALREPORT: "ANNUALREPORT"//年报表
}
// 服务名称
System.SERVICECODE = {
	ICP: "ICP",
	EDI: 'EDI',
	ICPANNUALREPORT: "ICPANNUALREPORT",
	EDIANNUALREPORT: "EDIANNUALREPORT",
	WANGWEN: "wangwen",
	PANNONG: "pannong",
	GUANGBO: "guangbo",
	COMPANYCASE: "companyCase",// 公司注册(带刻章)
	SEALSEVCASE: "sealSevCase",// 刻章服务
	TAXCONTROLCASE: "taxControlCase",// 税控申请
	TAXCASE: "taxCase",// 税务报道
	ICCHANGECASE: "icChangeCase",// 工商变更
	OPENBANKACCOUNTCASE: "openBankAccountCase",// 银行开户
	REGADDRCASE1: "regAddrCase1",// 注册地址服务（一年期)
	AGENTCASE1: "agentCase1" // 代理记账（一年期）

}
// 商机状态
System.BUSSTATUS = {
	WAITINGSCHEME: "beforeSubmission",//待提交方案
	WAITINGCONFIRM: "beforeConfirmation",//待用户确认
	FOLLOWINGUP: "followingUp",//跟进中
	SUCCESS: "isFinished",//已成交
	CLOSED: "isClosed"//需求关闭
}

// 方案状态
System.SCHEMESTATUS = {
	WAITINGCONFIRM: "beforeConfirmation",//待用户确认.
	CLOSED: "isClosed",//方案关闭
	REJECT: "isReject"//方案被拒绝
}

// 资质服务单状态
System.SERVERSESTATUS = {
	RECEIVED: "received",//已接单
	COLLECTING: "collecting",//收集材料中
	COLLECTSUCCESS: "collectsuccess",//收集材料完成
	SUBMITING: "submiting",//递交材料中 || 向工信部递交材料
	DISPOSEING: "disposeing",//工信部处理中 || 工信部已受理
	POSTING: "posting",//证书已邮寄
	SUCCESS: "success",//服务已完成
	CLOSED: "closed",//已关闭

	USERUPLOADWAIT: "userUploadWait",//待用户上传材料
	USERCONFIRMATIONWAIT: "userConfirmationWait",//递交文件待确认
	USERCONFIRMATIONREJECT: "userConfirmationReject",// 递交文件被驳回
	USERCONFIRMATIONRESOLVE: "userConfirmationResolve",//用户已确认递交文件

	ACCOUNTREGISTRATION: "accountRegistration",//账户注册
	THROUGH: "through",//工信部通过
	THROUGHFAIL: "throughFail", // 工信部未通过
	DISPOSEINGFAIL: "disposeingFail",// 工信部未受理

	AUDITING: "auditing",// 工商审核环节
	ENGRAVING: "engraving",// 刻章环节
	SERVICEING: "serviceing", // 服务中

	FILLING: "filling" //填写资料中 （易名渠道）
}
// 年报服务单状态
System.ANNUALREPORT = {
	RECEIVED: "received",//已接单
	WAITDECLARE: "waitdeclare",//待申报
	DECLARESUCCESS: "declaresuccess",//申报成功
	SUCCESS: "success",//服务已完成
	CLOSED: "closed",//已关闭
	TAKEEFFECT: "takeeffect"//生效
}

// 渠道名

System.SOURCENAME = {
	tencentCloud: "腾讯云",
	aliCloud: "阿里云"
}

/*
编码说明，
1000----1999  为请求参数验证和app权限验证
2000----2100  为请求用户信息操作验证，如：注册，登录，获取验证码，修改用户信息，修改用户密码
 */


System.objTable = {};
//访问token失效，请重新获取
System.tokenFail = 1000;
//appKey授权有误
System.appKeyError = 1100;
//应用处于待审核等待启用状态
System.waitAuditApp = 1110;
//获取访问token失败
System.getAppInfoFail = 1130;

//已经存在此用户，注册失败
System.existUserRegFail = 2000;
//用户名或密码错误
System.userLoginFail = 2010;
//用户名错误
System.userNameLoginFail = 2020;
//验证验证码错误
System.verifyVCodeFail = 2030;
//opencode存储的值已经失效
System.verifyOpencodeFail = 2040;

//重复操作
System.redoFail = 2050;
module.exports = System;

// (async ()=>{
// 	try{
// 		let d=await System.getReq("http://127.0.0.1:8001x/services")
// 		console.log(d)
// 	}catch(e){
//         console.log(e);
// 	}
// })()