var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class InvoiceCtl extends CtlBase {
  constructor() {
    super();
    this.invoiceSve = system.getObject("service.invoice.invoiceSve");
  }

  /**
   * 业务进度字典
   * @param {*} pobj 
   */
  async processDics(pobj, pobj2, req) {
    try {
      return await this.invoiceSve.processDics(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 发票申请列表-管理员
   * @param {*} pobj 
   */
  async invoicePage(pobj, pobj2, req) {
    try {
      this.doTimeCondition(pobj, ["createTimeBegin", "createTimeEnd"]);
      return await this.invoiceSve.invoicePage(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 发票申请列表-业务员
   * @param {*} pobj 
   */
  async myInvoicePage(pobj, pobj2, req) {
    try {
      pobj.operator_id = req.loginUser.id;
      this.doTimeCondition(pobj, ["createTimeBegin", "createTimeEnd"]);
      return await this.invoiceSve.invoicePage(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 进度处理
   * @param {*} pobj 
   */
  async handleStatus(pobj) {
    try {
      return await this.invoiceSve.handleStatus(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 根据ID查详细信息
   * @param {*} pobj 
   */
  async invoice(pobj, pobj2, req) {
    try {
      return await this.invoiceSve.invoice(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

}
module.exports = InvoiceCtl;