var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class OrderCtl extends CtlBase {
  constructor() {
    super();
    this.orderSve = system.getObject("service.order.orderSve");
  }

  async processList(pobj, pobj2, req) {
    try {
      return this.orderSve.allProcess(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async allOrders(pobj, pobj2, req) {
    var condition = {
      currentPage: Number(pobj.currentPage || 1),
      pageSize: Number(pobj.pageSize || 10),
      id: this.trim(pobj.id),
      status: pobj.status,
      createdBegin: this.trim(pobj.createdBegin),
      createdEnd: this.trim(pobj.createdEnd),
      deliver_id: pobj.deliver_id,
    }

    this.doTimeCondition(condition, ["createdBegin", "createdEnd"]);
    try {
      return await this.orderSve.orders(condition);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async myOrders(pobj, pobj2, req) {
    var condition = {
      currentPage: pobj.currentPage || 1,
      pageSize: pobj.pageSize || 10,
      id: this.trim(pobj.id),
      order_id: this.trim(pobj.order_id),
      operator_id: req.loginUser.id,
      deliver_id: this.trim(pobj.deliver_id),
      status: pobj.status,
      createdBegin: this.trim(pobj.createdBegin),
      createdEnd: this.trim(pobj.createdEnd),
    }
    this.doTimeCondition(condition, ["createdBegin", "createdEnd"]);
    try {
      return await this.orderSve.orders(condition);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

    async orderInfo(pobj, pobj2, req) {
    try {
      return await this.orderSve.orderInfoAll({id: this.trim(pobj.id)});
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async orderChooseProducts(pobj, pobj2, req) {
    let orderId = this.trim(pobj.id);

    let order = await this.orderSve.orderInfo({id: orderId});
    if(!order.data || !order.data.product_id) {
      return system.getResult(null, "订单不存在");
    }
    let params = {
      pid: order.data.product_id,
      is_choose: 1,
    }
    try {
      return await this.orderSve.productDics(params);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  /**
   * 分配业务员
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async deliverAssignSalesman(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 订单状态不能为空`);
    }
    if (!pobj.operator_id) {
      return system.getResult(null, `参数错误 业务员ID不能为空`);
    }
    
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

    /**
   * 工商注册中
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async businessRegister(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 订单状态不能为空`);
    }
    
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 工商注册完成
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async businessRegisterComplete(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 状态码不能为空`);
    }

    if (!pobj.name) {
      return system.getResult(null, `参数错误 个体工商户名称不能为空`);
    }
    if (!pobj.credit_code) {
      return system.getResult(null, `参数错误 统一社会信用代码不能为空`);
    }
    if (!pobj.business_place) {
      return system.getResult(null, `参数错误 经营场所不能为空`);
    }
    if (!pobj.business_scope) {
      return system.getResult(null, `参数错误 经营范围不能为空`);
    }
    if (!pobj.reg_date) {
      return system.getResult(null, `参数错误 注册日期不能为空`);
    }
    if (!pobj.business_img) {
      return system.getResult(null, `参数错误 执照照片不能为空`);
    }
    // if (!pobj.business_gov_file) {
    //   return system.getResult(null, `参数错误 工商官方文件不能为空`);
    // }

    pobj.bd_id = req.loginUser.id;
    pobj.bd_path = req.loginUser.orgpath;

    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


  /**
   * 刻章办理中
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async chapterEngraving(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 状态码不能为空`);
    }
    
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 刻章办理已完成
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async chapterEngravedComplete(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 状态码不能为空`);
    }

    // if (!pobj.gongzhang) {
    //   return system.getResult(null, `参数错误 公章不能为空`);
    // }
    // if (!pobj.fapiaozhang) {
    //   return system.getResult(null, `参数错误 发票章不能为空`);
    // }
    // if (!pobj.caiwuzhang) {
    //   return system.getResult(null, `参数错误 财务章不能为空`);
    // }
    // if (!pobj.hetongzhang) {
    //   return system.getResult(null, `参数错误 合同章不能为空`);
    // }
    // if (!pobj.farenzhang) {
    //   return system.getResult(null, `参数错误 法人章不能为空`);
    // }
    // if (!pobj.zhang_gov_file) {
    //   return system.getResult(null, `参数错误 刻章官方文件不能为空`);
    // }
    
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 银行开户中
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async backAccountOpening(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 状态码不能为空`);
    }
    
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 银行已开户
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async backAccountOpenComplete(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 状态码不能为空`);
    }
    if (!pobj.bank_name) {
      return system.getResult(null, `参数错误 账户名称不能为空`);
    }
    if (!pobj.bank_no) {
      return system.getResult(null, `参数错误 账户号不能为空`);
    }
    if (!pobj.bank) {
      return system.getResult(null, `参数错误 开户行不能为空`);
    }
    // if (!pobj.bank_img) {
    //   return system.getResult(null, `参数错误 账户信息不能为空`);
    // }
    // if (!pobj.bank_gov_file) {
    //   return system.getResult(null, `参数错误 银行开户官方文件不能为空`);
    // }
    
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 税务报道中
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async taxReporting(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 状态码不能为空`);
    }
    
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

    /**
   * 税务报道完成
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async taxReportComplete(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 状态码不能为空`);
    }
    if (!pobj.tax_reg_day) {
      return system.getResult(null, `参数错误 税务登记日不能为空`);
    }
    if (!pobj.tax_org) {
      return system.getResult(null, `参数错误 税务机构名称不能为空`);
    }
    // if (!pobj.ca_img) {
    //   return system.getResult(null, `参数错误 CA照片不能为空`);
    // }
    // if (!pobj.tax_gov_file) {
    //   return system.getResult(null, `参数错误 税务报道官方文件不能为空`);
    // }
    
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 核定税种
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async taxCategoryDetermine(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 状态码不能为空`);
    }
    if (!pobj.common_tax_ladder) {
      return system.getResult(null, `参数错误 普票个税阶梯不能为空`);
    }
    if (!pobj.common_other_ladder) {
      return system.getResult(null, `参数错误 普票增值税、附加税阶梯不能为空`);
    }
    if (!pobj.special_tax_ladder) {
      return system.getResult(null, `参数错误 专票个税阶梯不能为空`);
    }
    if (!pobj.special_other_ladder) {
      return system.getResult(null, `参数错误 专票增值税、附加税阶梯不能为空`);
    }
    if (!pobj.add_value_up_type) {
      return system.getResult(null, `参数错误 增值税累计类型不能为空`);
    }
    if (!pobj.tax_up_type) {
      return system.getResult(null, `参数错误 个税累计类型不能为空`);
    }
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 交付商提交审核
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async submitAudit(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 状态码不能为空`);
    }
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

    /**
   * 交付商订单交付
   * @param {*} pobj 
   * @param {*} pobj2 
   * @param {*} req 
   */
  async mailed(pobj, pobj2, req) {
    if (!pobj.id) {
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if (!pobj.status) {
      return system.getResult(null, `参数错误 状态码不能为空`);
    }
    if (!pobj.deliver_mail_no) {
      return system.getResult(null, `参数错误 交付商交付快递单号不能为空`);
    }
    if (!pobj.deliver_mail_img) {
      return system.getResult(null, `参数错误 交付商交付快递单号图片不能为空`);
    }
    try {
      return await this.orderSve.handleStatus(pobj);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


}
module.exports = OrderCtl;