var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class OrgCtl extends CtlBase {
  constructor() {
    super();
    this.orgSve = system.getObject("service.uc.orgSve");
  }

    /**
   * 组织机构  添加 
   * @param {*} params 
   */
  async addOrg(params, pobj2, req) {
    try {
      params.saas_id = req.loginUser.saas_id;
      return await this.orgSve.addOrg(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 组织机构  更新
   * @param {*} params 
   */
  async updOrg(params, pobj2, req) {
    params.saas_id = req.loginUser.saas_id;
    try {
      return await this.orgSve.updOrg(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 组织机构 删除 
   * @param {*} params 
   */
  async delOrg(params, pobj2, req) {
    params.saas_id = req.loginUser.saas_id;
    try {
      return await this.orgSve.delOrg(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  /**
   * 组织机构  查询列表 
   * @param {*} params 
   */
  async listOrg(params, pobj2, req) {
    try {
      params.saas_id = req.loginUser.saas_id;
      return await this.orgSve.listOrg(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 组织机构  查询明细
   * @param {*} params 
   */
  async queryById(params, pobj2, req) {
    try {
      return await this.orgSve.queryById(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 根据pid查出子目录
   * @param {*} params 
   */
  async byPid(params, pobj2, req) {
    params.saas_id = req.loginUser.saas_id;

    try {
      return await this.orgSve.byPid(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 查询整个树结构
   * @param {*} params 
   */
  async tree(params, pobj2, req) {
    params.saas_id = req.loginUser.saas_id;

    try {
      return await this.orgSve.tree(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

}
module.exports = OrgCtl;