var system = require("../../../system")
const settings = require("../../../../config/settings")
const CtlBase = require("../../ctlms.base");
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
const logCtl = system.getObject("web.common.oplogCtl");


class UserCtl extends CtlBase {
  constructor() {
    super();
    this.userSve = system.getObject("service.uc.userSve");
    this.redisClient = system.getObject("util.redisClient");
    this.captchaSve = system.getObject("service.common.captchaSve");
    this.deliverSve = system.getObject("service.common.deliverSve");

    this.redisClientTax = system.getObject("util.redisClientTax");
  }

  async login(pobj, pobj2, req, res) {
    var loginName = this.trim(pobj.loginName);
    var password = this.trim(pobj.password);
    // var captchaKey = this.trim(pobj.captchaKey);
    // var captchaCode = this.trim(pobj.captchaCode);

    try {
      // var vrs = await this.captchaSve.valid({
      //   key: captchaKey,
      //   code: captchaCode,
      // });
      // if (vrs.status !== 0) {
      //   return vrs;
      // }

      var loginUser = await this.deliverSve.login({
        ucname: loginName,
        password: password,
      });
      if (loginUser.status != 0) {
        return loginUser;
      }

      loginUser = loginUser.data;
      var loginKey = await this.setLogin(loginUser);
      let ntapi = settings.ntapi();
      let rs = {
        key: loginKey.xggadminsid,
        taxLoginUrl: ntapi.taxLoginUrl + `?username=${loginUser.ucname}&cookieId=${loginKey.subsid}&target=tax`,
        finLoginUrl: ntapi.taxLoginUrl + `?username=${loginUser.ucname}&cookieId=${loginKey.subsid}`,
        loginname: loginUser.ucname,
        auth: loginUser.auth,
        isManager: loginUser.isManager,
        menus: {gtArr: this.getOrderMenu(loginUser), pjArr: this.getInvoiceMenu(loginUser)}
      };

      return system.getResultSuccess(rs);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async setLogin(user) {
    user.loginsid = "jfs_" + uuidv4();
    user.subsid = "sub_" + uuidv4();
    if(settings.env == 'dev') {
      user.loginsid = "jfs_" + "3cb49932-fa02-44f0-90db-9f06fe02e5c7";
      user.subsid = "sub_" +  "3cb49932-fa02-44f0-90db-9f06fe02e5c7";
    }
    // xggadminsid = "jfs_" + "3cb49932-fa02-44f0-90db-9f06fe02e5c7";
    await this.redisClient.setWithEx(user.loginsid, JSON.stringify(user), 60 * 60 * 5);
    await this.redisClientTax.setWithEx(user.subsid, (user.nt_user_id || "").toString(), 60 * 60 * 5);
    return {
      xggadminsid: user.loginsid,
      subsid: user.subsid,
    };
  }

  async getMenu(qobj, pobj, req) {
    // return system.getResultSuccess(req.loginUser.menus);
    let loginUser = req.loginUser;
    if (!loginUser) {
      return system.getResultSuccess({gtArr: [], pjArr: []})
    }

    let gtArr = this.getOrderMenu(loginUser);
    let pjArr = this.getInvoiceMenu(loginUser);
    return system.getResultSuccess({gtArr: gtArr, pjArr: pjArr});
  }

  getOrderMenu(loginUser) {
    if (!loginUser) {
      return [];
    }
    if (loginUser.isAdmin) {
      return [
        {
          "name": "数据概览",
          "icon": "iconfont icon-gth-gsshujugailan",
          "team": [
            {
              "name": "业务数据汇总",
              "path": "/home"
            }
          ]
        },
        {
          "name": "订单中心",
          "icon": "iconfont icon-gth-gsdingdanzhongxin",
          "team": [
            {
              "name": "订单管理",
              "path": "/trading/ordersAll"
            },
          ]
        },
        {
          "name": "个体户中心",
          "icon": "iconfont icon-gth-gsgetihuzhongxin",
          "team": [
            {
              "name": "个体户管理",
              "path": "/trading/userInformation"
            },
          ]
        },
        // {
        //   "name": "用户中心",
        //   "icon": "iconfont icon-gth-gsgetihuzhongxin",
        //   "team": [
        //     {
        //       "name": "用户管理",
        //       "path": "/user/userCenter"
        //     }
        //   ]
        // }
      ];
    } else {
      return [
        {
          "name": "数据概览",
          "icon": "iconfont icon-gth-gsshujugailan",
          "team": [
            {
              "name": "业务数据汇总",
              "path": "/home"
            }
          ]
        },
        {
          "name": "订单中心",
          "icon": "iconfont icon-gth-gsdingdanzhongxin",
          "team": [
            {
              "name": "我的业务订单",
              "path": "/trading/orderInformation"
            }
          ]
        },
        {
          "name": "个体户中心",
          "icon": "iconfont icon-gth-gsgetihuzhongxin",
          "team": [
            {
              "name": "个体户",
              "path": "/trading/userAll"
            }
          ]
        }
      ];
    }
  }

  getInvoiceMenu(loginUser) {
    if (!loginUser) {
      return [];
    }
    return [
      {
        name: "数据概览",
        icon: "iconfont icon-gth-gsshujugailan",
        team: [{name: "业务数据汇总", path: "/home"}]
      },
      {
        name: "发票中心",
        icon: "iconfont icon-gth-gsfapiaozhongxin",
        team: [
          {name: "发票申请", path: "/trading/invoiceApplyFor"},
          {name: "发票管理", path: "/trading/invoiceManagement"},
        ]
      }
    ];
  }

  /**
   *   添加
   * @param {*} params
   */
  async addUser(params, pobj2, req) {
    try {
      var user = {
        saas_id: params.saas_id,
        org_id: Number(params.org_id || 0),
        ucname: this.trim(params.ucname),
        password: this.trim(params.password),
        uctype: '3',
        uctypeId: this.trim(params.deliverId),
        mobile: this.trim(params.mobile),
        realName: this.trim(params.realName),
        roles: params.roles || [],
      };
      if (!user.ucname) {
        return system.getResult(null, "请填写用户名");
      }
      if (!user.password) {
        return system.getResult(null, "请填写密码");
      }
      if (!user.mobile) {
        return system.getResult(null, "请填写手机号");
      }
      if (!user.realName) {
        return system.getResult(null, "请填写姓名");
      }

      if (user.uctype != 1) {
        user.org_id = null;
        user.roles = [];
      }
      return await this.userSve.addUser(user);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   *   更新
   * @param {*} params
   */
  async updUser(params, pobj2, req) {
    var user = {
      id: Number(params.id || 0),
      saas_id: params.saas_id,
      org_id: Number(params.org_id || 0),
      uctype: '3',
      uctypeId: this.trim(params.deliverId),
      mobile: this.trim(params.mobile),
      realName: this.trim(params.realName),
      roles: params.roles || [],
    };

    if (!user.id) {
      return system.getResult(null, "用户不存在");
    }

    if (!user.mobile) {
      return system.getResult(null, "请填写手机号");
    }

    if (!user.realName) {
      return system.getResult(null, "请填写姓名");
    }

    if (user.uctype != 1) {
      user.org_id = null;
      user.roles = [];
    }

    try {
      return await this.userSve.updUser(user);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async currentUser(qobj, pobj, req) {
    return system.getResultSuccess(req.loginUser);
  }

  /**
   * 启用禁用
   * @param {*} params
   * @param {*} pobj2
   * @param {*} req
   */
  async enabled(params, pobj2, req) {
    try {
      params.id = Number(params.id || 0);
      params.enabled = Number(params.enabled || 0);
      return await this.userSve.enabled(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async delUser(params, pobj2, req) {
    try {
      return await this.userSve.delUser(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   *   查询明细
   * @param {*} params
   */
  async queryById(params, pobj2, req) {
    try {
      return await this.userSve.queryById(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async updPassword(params, pobj2, req) {
    params.password = this.trim(params.password);
    if (!params.password) {
      return system.getResult(null, `请填写密码`);
    }

    try {
      return await this.userSve.updPassword(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 根据pid查出子目录
   * @param {*} params
   */
  async page(params, pobj2, req) {
    try {
      params.uctypeId = params.deliver_id;
      return await this.userSve.page(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async salesmanList(params, pobj2, req) {
    try {
      if (!params.deliver_id) {
        return system.getResultSuccess([]);
      }
      return await this.userSve.salesmanList(params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}

module.exports = UserCtl;