const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings")
class MerchantService extends ServiceBase {
  constructor() {
    super();
  }

  //查询商户
  async apiQueryMerchant(params) {
    try {
      return  await this.queryMerchant(params);
    } catch (error) {
      return system.getResultFail(-1); 
    }
  }
  
  // ----------------------------------- 以上为api --------------------------------------

  async queryMerchant(params) {
    try {
      var p = {
        id : params.merchant_id || params.merchantId,
        options: {
          title: true,
          address:true,
        }
      }
      var rs = await this.callms("merchant", "getById", p);
      if(rs.status != 0 || !rs.data) {
        return system.getResult(null, "商户不存在");
      }

      let merchant ={};
      merchant.name=rs.data.name;
      merchant.taxType=rs.data.taxType;
      merchant.contactName=rs.data.contactName;
      merchant.contactMobile=rs.data.contactMobile;
      merchant.contactEmail=rs.data.contactEmail;
      merchant.invoiceValid=rs.data.invoiceValid;
      merchant.mustPay=rs.data.mustPay;
      merchant.status=rs.data.status;
      merchant.ownerName=rs.data.ownerName;
      merchant.ownerMobile=rs.data.ownerMobile;
      merchant.created_at=rs.data.created_at;

      merchant.titleList=[];
      for (let item of rs.data.titleList) {
        let temp={};
        temp.titleNo=item.titleNo;
        temp.taxNo=item.taxNo;
        temp.invoiceAddr=item.invoiceAddr;
        temp.invoiceMobile=item.invoiceMobile;
        temp.accountName=item.accountName;
        temp.accountPublic=item.accountName;
        merchant.titleList.push(temp);
      }

      merchant.addressList=[];
      for (let item of rs.data.addressList) {
        let temp={};
        temp.addressNo=item.addressNo;
        temp.mailAddr=item.mailAddr;
        temp.mailTo=item.mailTo;
        temp.mailMobile=item.mailMobile;
        merchant.addressList.push(temp);
      }
      return system.getResultSuccess(merchant);
    } catch (error) {
      return system.getResultFail(-1); 
    }
  }

  async nameList() {
    var rs = await this.callms("merchant", "nameList", {});
    return rs;
  }

  async infoPage(params) {
    var rs = await this.callms("merchant", "infoList", params);
    return rs;
  }

  async getById(id) {
    var rs = await this.callms("merchant", "getById", {id: id});
    return rs;
  }

  async add(params) {
    var merchant = {};
    var title = {};
    var address = {};

    if(["00", "10"].indexOf(params.taxType) == -1) {
      return system.getResult(null, "纳税人类型类型错误");
    }

    // 商户信息
    merchant.name = this.trim(params.name);
    merchant.taxType = params.taxType;
    merchant.contactName = this.trim(params.contactName);
    merchant.contactMobile = this.trim(params.contactMobile);
    merchant.contactEmail = this.trim(params.contactEmail);
    merchant.invoiceValid = params.invoiceValid ? 1 : 0;
    merchant.mustPay = params.mustPay ? 1 : 0;
    merchant.status = "00";

    merchant.ownerId = this.trim(params.ownerId);
    if(merchant.ownerId) {
      // TODO 去用户平台查询用户信息
      merchant.ownerName = "测试用户名";
      merchant.ownerMobile = "测试用户手机号";
      merchant.ownerPath = "/aaa/bbbb/ccc/ddd/eee/fff/zzz/yyy";
    }

    title.taxNo = this.trim(params.taxNo);
    title.invoiceAddr = this.trim(params.invoiceAddr);
    title.invoiceMobile = this.trim(params.invoiceMobile);
    title.accountName = this.trim(params.accountName);
    title.accountPublic = this.trim(params.accountPublic);

    address.mailAddr = this.trim(params.mailAddr);
    address.mailTo = this.trim(params.mailTo);
    address.mailMobile = this.trim(params.mailMobile);

    merchant.title = title;
    merchant.address = address;

    return await this.callms("merchant", "addMerchant", merchant);
  }

  async upd(params) {
    var merchant = {};
    var title = {};
    var address = {};

    if(["00", "10"].indexOf(params.taxType) == -1) {
      return system.getResult(null, "纳税人类型类型错误");
    }

    // 商户信息
    merchant.id = params.id;
    merchant.name = this.trim(params.name);
    merchant.taxType = params.taxType;
    merchant.contactName = this.trim(params.contactName);
    merchant.contactMobile = this.trim(params.contactMobile);
    merchant.contactEmail = this.trim(params.contactEmail);
    merchant.invoiceValid = params.invoiceValid ? 1 : 0;
    merchant.mustPay = params.mustPay ? 1 : 0;
    merchant.status = "00";

    merchant.ownerId = this.trim(params.ownerId);
    if(merchant.ownerId) {
      // TODO 去用户平台查询用户信息
      merchant.ownerName = "测试用户名";
      merchant.ownerMobile = "测试用户手机号";
      merchant.ownerPath = "/aaa/bbbb/ccc/ddd/eee/fff/zzz/yyy";
    }

    return await this.callms("merchant", "updMerchant", merchant);
  }

  async audit(params) {
    var mobile = this.trim(params.mobile);
    var ucname = this.trim(params.mobile);

    params.status = "10";
    params.ucname = ucname;
    params.ucid = ucid;
    // TODO 调用平台，创建商户用户
    var auditRs = await this.callms("merchant", "auditMerchant", params);
    return auditRs;
  }
}
module.exports = MerchantService;
