const system=require("../../../system");
const ServiceBase=require("../../svems.base")
const settings=require("../../../../config/settings")
class MerchantaccountService extends ServiceBase{
  constructor(){
     super();
  }

  async page(params) {
    var res = await this.callms("merchant", "merchantAccountPage", params);
    await this.trans(res.data.rows);
    return res;
  }

  async infoByMerchantId(params) {
    var merchantId = params.merchantId || params.merchant_id;
    var res = await this.callms("merchant", "merchantAccountInfoByMerchantId", {merchantId : merchantId});
    if(res.status != 0 || !res.data) {
      return res;
    }
    var info = res.data;

    var dto = {
      "merchant_id": info.merchant_id,
      "banlance": info.banlance
    };
 
    return system.getResultSuccess(dto);
  }

  async trans(rows) {
    if (!rows) {
      return;
    }
    for (var item of rows) {
      if (!item) {
        continue;
      }
      item.banlance = system.f2y(item.banlance);
    }
  }
}
module.exports=MerchantaccountService;
// var task=new UserService();
// task.getUserStatisticGroupByApp().then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
