const system = require("../system");
const moment = require('moment');
const settings = require("../../../app/config/settings");

class APIBase {
    constructor() {
        this.redisClient = system.getObject("util.redisClient");
        this.execClient = system.getObject("util.execClient");
        this.esUtils = system.getObject("util.esUtils");
    }
    //-----------------------新的模式------------------开始

    async doexecMethod(gname, methodname, pobj, query, req) {
        try {
            if (!pobj.actionBody) {
                pobj.actionBody = {};
            }
            var result = await this[methodname](pobj, query, req);
            if (!result) {
                result = system.getResult(null, "请求的方法返回值为空");
            }
            result.requestId = await this.getBusUid("scz");
            if ("LOGS-SYTXPUBLIC-MSGQ" != settings.queuedName) {
                pobj.actionBody.resultInfo = result;
                pobj.actionBody.requestId = result.requestId;
                pobj.actionBody.opTitle = "reqPath:" + req.path;
                this.esUtils.addEsLogs(settings.queuedName + "api-req", pobj.actionBody);
            }
            return result;
        } catch (e) {
            var stackStr = e.stack ? e.stack : JSON.stringify(e);
            console.log(stackStr, "api.base调用出现异常，请联系管理员..........");
            var rtnerror = system.getResultFail(-200, "出现异常，error：" + stackStr);
            pobj.actionBody.requestId = await this.getBusUid("err");
            pobj.actionBody.errorInfo = stackStr;
            pobj.actionBody.opTitle = "，reqPath:" + req.path;
            this.esUtils.addEsLogs(settings.queuedName + "apidoexec-error", pobj.actionBody);
            return rtnerror;
        }
    }

    //-----------------------新的模式------------------结束
    /**
     * 带超时时间的post请求
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     */
    async execPostByTimeOut(params, url, ContentType, headData, timeOut = 60) {
        return await this.execClient.execPostTimeOutByBusiness("api.base", params, url, ContentType, headData, timeOut);
    }
    /**
     * 返回20位业务订单号
     * @param {*} prefix 业务前缀
     */
    async getBusUid(prefix) {
        prefix = (prefix || "");
        if (prefix) {
            prefix = prefix.toUpperCase();
        }
        var prefixlength = prefix.length;
        var subLen = 8 - prefixlength;
        var uidStr = "";
        if (subLen > 0) {
            uidStr = await this.getUidInfo(subLen, 60);
        }
        var timStr = moment().format("YYYYMMDDHHmm");
        return prefix + timStr + uidStr;
    }
    /**
     * 返回指定长度的字符串
     * @param {*} len 返回长度
     * @param {*} radix 参与计算的长度，最大为62
     */
    async getUidInfo(len, radix) {
        var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
        var uuid = [], i;
        radix = radix || chars.length;
        if (len) {
            for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
        } else {
            var r;
            uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
            uuid[14] = '4';
            for (i = 0; i < 36; i++) {
                if (!uuid[i]) {
                    r = 0 | Math.random() * 16;
                    uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
                }
            }
        }
        return uuid.join('');
    }
}
module.exports = APIBase;
