var APIBase = require("../../api.base");
var system = require("../../../system");

class IcQueryAPI extends APIBase {
    constructor() {
        super();
        this.utilsIcSve = system.getObject("service.utilsSve.utilsIcSve");
    }
    /**
  * 接口跳转-POST请求
  * actionType     执行的功能模块
  * actionBody     执行的参数
  */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionType(pobj, pobj.actionType, req);
        return result;
    }
    async opActionType(pobj, actionType, req) {
        var opResult = null;
        switch (actionType) {
            case "getListByLikeCompanyName":
                opResult = await this.utilsIcSve.getListByLikeCompanyName(pobj.actionBody);
                break;
            case "getItemByCompanyName":
                opResult = await this.utilsIcSve.getItemByCompanyName(pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "actionType参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = IcQueryAPI;