var APIBase = require("../../api.base");
var system = require("../../../system");
const settings = require("../../../../config/settings");

class ProducerAPI extends APIBase {
    constructor() {
        super();
        this.utilsProduceSve = system.getObject("service.utilsSve.utilsProduceSve");
    }
    /**
  * 接口跳转-POST请求
  * actionType     执行的功能模块
  * actionBody     执行的参数
  */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionType(pobj, pobj.actionType, req);
        return result;
    }
    async opActionType(pobj, actionType, req) {
        var opResult = null;
        switch (actionType) {
            case "produceData":
                opResult = await this.utilsProduceSve.produceData(pobj, req);
                break;
            case "produceLogsData":
                if (settings.queuedName != "LOGS-SYTXPUBLIC-MSGQ") {
                    return system.getResult(null, "请求地址有误!");
                }
                opResult = await this.utilsProduceSve.produceLogsData(pobj, req);
                break;
            default:
                opResult = system.getResult(null, "actionType参数错误");
                break;
        }
        return opResult;
    }
}
module.exports = ProducerAPI;