const system = require("../../../system");
const Dao = require("../../dao.base");
class ConfigInfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(ConfigInfoDao));
    this.configInfoCacheKey = "queue-configuration:info";
    this.redisClient = system.getObject("util.redisClient");
  }
  /**
   * 获取配置信息列表，缓存600s
   */
  async getList() {
    var cacheStr = await this.redisClient.getCache(this.configInfoCacheKey);
    if (cacheStr && cacheStr != "undefined") {
      var list = JSON.parse(cacheStr);
      return system.getResultSuccess(list);
    }
    var list = await this.model.findAll({
      where: { is_enabled: 1 },
      raw: true,
      attributes: [
        "c_key",
        "c_value"
      ]
    });
    if (!list || list.length === 0) {
      return system.getResult(null, "data is empty!");
    }
    cacheStr = JSON.stringify(list);
    this.redisClient.setWithEx(this.configInfoCacheKey, cacheStr, 600);
    var result = await system.getResultSuccess(list);
    return result;
  }
}
module.exports = ConfigInfoDao;
