const system = require("../../../system");
const Dao = require("../../dao.base");
const settings = require("../../../../config/settings");

class ErrorLogDao extends Dao {
  constructor() {
    super(Dao.getModelName(ErrorLogDao));
  }
  /**
   * 添加错误日志
   * @param {*} opTitle  操作标题
   * @param {*} actionBody 操作的消息体
   * @param {*} execResult 操作的返回信息
   * @param {*} error 错误信息
   * @param {*} logLevel 日志级别信息,debug: 0, info: 1, warn: 2, error: 3, fatal: 4
   */
  async addOpErrorLogs(opTitle, actionBody, execResult, error, logLevel) {
    error = typeof error === 'object' ? error : { error_info: error };
    var params = {
      queued_name: settings.queuedName,
      identify_code: actionBody.identifyCode,
      op_title: opTitle,
      push_content: actionBody || null,
      error_info: error || null,
      result_info: execResult || null,
      request_id: actionBody.requestId,
      client_ip: actionBody.clientIp || "",
      created_at: new Date()
    }
    await this.create(params);
    return system.getResultSuccess();
  }
}
module.exports = ErrorLogDao;
