const system = require("../../../system");
const Dao = require("../../dao.base");
class PushSuccessLogDao extends Dao {
  constructor() {
    super(Dao.getModelName(PushSuccessLogDao));
  }

  /**
   * 添加成功日志
   * @param {*} opTitle  操作标题
   * @param {*} actionBody 操作的消息体
   * @param {*} execResult 操作的返回信息
   */
  async addOpSuccessLogs(opTitle, actionBody, execResult) {
    var params = {
      identify_code: actionBody.identifyCode,
      op_title: opTitle,
      push_content: actionBody,
      result_info: execResult,
      request_id: actionBody.requestId,
      client_ip: actionBody.clientIp || "",
      created_at: new Date()
    }
    await this.create(params);
    return system.getResultSuccess();
  }
}
module.exports = PushSuccessLogDao;
