const system = require("../../../system");
const AppServiceBase = require("../../app.base");
const settings = require("../../../../config/settings");
const moment = require('moment');
//用户权限操作
class UtilsIcService extends AppServiceBase {
  constructor() {
    super();
    this.esUtils = system.getObject("util.esUtils");
  }
  /**
     * 公司模糊查询
     * actionBody     {companyName:公司名称,currentPage:第几页,pageSize:每页大小}
     */
  async getListByLikeCompanyName(actionBody) {
    if (!actionBody.companyName) {
      return system.getResult(null, "companyName　can not be empty");
    }
    actionBody.companyName = await this.getConvertSemiangleStr(actionBody.companyName);
    var pageSize = !actionBody.pageSize ? 15 : Number(actionBody.pageSize);
    if (pageSize < 0) {
      pageSize = 15;
    }
    var from = !actionBody.currentPage ? 0 : Number((actionBody.currentPage - 1) * pageSize);
    if (from < 0) {
      from = 0;
    }

    var esIndexName = "tx_ic_bigdata_business_index/_search";
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "query_string": {
                "default_field": "company_name",
                "query": '\"' + actionBody.companyName + '\"'
              }
            }
          ]
        }
      },
      "from": from,
      "size": pageSize,
      "_source": [
        "company_name"//公司名称
        // "company_org_type",//公司类型
        // "credit_code",//统一社会信用代码
        // "legal_person",//法人姓名
        // "from_time",//营业期限开始日期
        // "to_time",//营业期限结束日期
        // "estiblish_time",//成立时间
        // "reg_status",//公司状态
        // "reg_number",//注册号
        // "org_number",//组织机构代码
        // "reg_location",//公司地址
        // "reg_capital",//注册资本
        // "business_scope",//公司经营范围
        // "reg_institute",//登记机关
        // "company_province",//公司省份
        // "company_city",//公司二级市
        // "company_cate_1",//行业分类一级分类
        // "company_cate_2",//行业分类二级分类
        // "company_cate_3"//行业分类三级分类
      ]
      // ,
      // "sort": [
      //   {
      //     "reg_capital": "desc"
      //   }
      // ]
    }


    var resultData = null;
    try {
      resultData = await this.esUtils.execPostEs(settings.queuedName, params, esIndexName);
      var sources = [];
      var data = {
        "totalCount": resultData.data.hits.total,
        "pageSize": pageSize,
        "currentPage": from === 0 ? from : (from - 1),
        "list": sources
      };
      if (!resultData.data.hits) {
        return system.getResult(null, "data is empty");
      }
      if (!resultData.data.hits.hits || resultData.data.hits.hits.length === 0) {
        return system.getResult(null, "data is empty!");
      }
      resultData.data.hits.hits.forEach(function (c) {
        var source = {
          "companyName": c._source.company_name//公司名称
          // "companyOrgType": c._source.company_org_type || "",//公司类型
          // "creditCode": c._source.credit_code || "",//统一社会信用代码
          // "legalPerson": c._source.legal_person,//法人姓名
          // "fromTime": c._source.from_time ? moment(c._source.from_time * 1000).format("YYYY-MM-DD") : "",//营业期限开始日期
          // "toTime": c._source.to_time ? moment(c._source.to_time * 1000).format("YYYY-MM-DD") : "",//营业期限结束日期
          // "estiblishTime": c._source.estiblish_time ? moment(c._source.estiblish_time * 1000).format("YYYY-MM-DD") : "",//成立时间
          // "regStatus": c._source.reg_status || "",//公司状态
          // "regNumber": c._source.reg_number || "",//注册号
          // "orgNumber": c._source.org_number || "",//组织机构代码
          // "regLocation": c._source.reg_location || "",//公司地址
          // "regCapital": c._source.reg_capital || "",//注册资本
          // "businessScope": c._source.business_scope || "",//公司经营范围
          // "regInstitute": c._source.reg_institute || "",//登记机关
          // "companyProvince": c._source.company_province || "",//公司省份
          // "companyCity": c._source.company_city || "",//公司二级市
          // "companyCate1": c._source.company_cate_1 || "",//行业分类一级分类
          // "companyCate2": c._source.company_cate_2 || "",//行业分类二级分类
          // "companyCate3": c._source.company_cate_3 || ""//行业分类三级分类	

        };
        sources.push(source);
      });
      return system.getResultSuccess(data);
    } catch (e) {
      console.log(e.stack, ".. getListByLikeCompanyName query is error");
      //TODO:日志
      return system.getResultError("query is error");
    }
  }

  /**
     * 公司精确查询
     * actionBody     {companyName:公司名称}
     */
  async getItemByCompanyName(actionBody) {
    if (!actionBody.companyName) {
      return system.getResult(null, "companyName　can not be empty");
    }
    actionBody.companyName = await this.getConvertSemiangleStr(actionBody.companyName);
    var esIndexName = "tx_ic_bigdata_business_index/_search";
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "term": {
                "company_name.raw": actionBody.companyName
              }
            }
          ]
        }
      },
      "from": 0,
      "size": 1,
      "_source": [
        "company_name",//公司名称
        "company_org_type",//公司类型
        "credit_code",//统一社会信用代码
        "legal_person",//法人姓名
        "from_time",//营业期限开始日期
        "to_time",//营业期限结束日期
        "estiblish_time",//成立时间
        "reg_status",//公司状态
        "reg_number",//注册号
        "org_number",//组织机构代码
        "reg_location",//公司地址
        "reg_capital",//注册资本
        "business_scope",//公司经营范围
        "reg_institute",//登记机关
        "company_province",//公司省份
        "company_city",//公司二级市
        "company_cate_1",//行业分类一级分类
        "company_cate_2",//行业分类二级分类
        "company_cate_3"//行业分类三级分类
      ]
      // ,
      // "sort": [
      //   {
      //     "reg_capital": "desc"
      //   }
      // ]
    }


    var resultData = null;
    try {
      resultData = await this.esUtils.execPostEs(settings.queuedName, params, esIndexName);
      if (!resultData.data.hits) {
        return system.getResult(null, "data is empty");
      }
      if (!resultData.data.hits.hits || resultData.data.hits.hits.length === 0) {
        return system.getResult(null, "data is empty!");
      }
      var item = {
        "companyName": resultData.data.hits.hits[0]._source.company_name,//公司名称
        "companyOrgType": resultData.data.hits.hits[0]._source.company_org_type || "",//公司类型
        "creditCode": resultData.data.hits.hits[0]._source.credit_code || "",//统一社会信用代码
        "legalPerson": resultData.data.hits.hits[0]._source.legal_person,//法人姓名
        "fromTime": resultData.data.hits.hits[0]._source.from_time ? moment(resultData.data.hits.hits[0]._source.from_time * 1000).format("YYYY-MM-DD") : "",//营业期限开始日期
        "toTime": resultData.data.hits.hits[0]._source.to_time ? moment(resultData.data.hits.hits[0]._source.to_time * 1000).format("YYYY-MM-DD") : "",//营业期限结束日期
        "estiblishTime": resultData.data.hits.hits[0]._source.estiblish_time ? moment(resultData.data.hits.hits[0]._source.estiblish_time * 1000).format("YYYY-MM-DD") : "",//成立时间
        "regStatus": resultData.data.hits.hits[0]._source.reg_status || "",//公司状态
        "regNumber": resultData.data.hits.hits[0]._source.reg_number || "",//注册号
        "orgNumber": resultData.data.hits.hits[0]._source.org_number || "",//组织机构代码
        "regLocation": resultData.data.hits.hits[0]._source.reg_location || "",//公司地址
        "regCapital": resultData.data.hits.hits[0]._source.reg_capital || "",//注册资本
        "businessScope": resultData.data.hits.hits[0]._source.business_scope || "",//公司经营范围
        "regInstitute": resultData.data.hits.hits[0]._source.reg_institute || "",//登记机关
        "companyProvince": resultData.data.hits.hits[0]._source.company_province || "",//公司省份
        "companyCity": resultData.data.hits.hits[0]._source.company_city || "",//公司二级市
        "companyCate1": resultData.data.hits.hits[0]._source.company_cate_1 || "",//行业分类一级分类
        "companyCate2": resultData.data.hits.hits[0]._source.company_cate_2 || "",//行业分类二级分类
        "companyCate3": resultData.data.hits.hits[0]._source.company_cate_3 || ""//行业分类三级分类	
      };
      return system.getResultSuccess(item);
    } catch (e) {
      //TODO:日志
      console.log(e.stack, ".. getItemByCompanyName query is error");
      return system.getResultError("query is error");
    }
  }

  async getConvertSemiangleStr(str) {
    var result = "";
    str = str.replace(/\s+/g, "");
    var len = str.length;
    for (var i = 0; i < len; i++) {
      var cCode = str.charCodeAt(i);
      //全角与半角相差（除空格外）：65248（十进制）
      cCode = (cCode >= 0xFF01 && cCode <= 0xFF5E) ? (cCode - 65248) : cCode;
      //处理空格
      cCode = (cCode == 0x03000) ? 0x0020 : cCode;
      result += String.fromCharCode(cCode);
    }
    return result;
  }
}
module.exports = UtilsIcService;
