const system = require("../../../system");
const settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
//用户权限操作
class UtilsProduceService extends AppServiceBase {
  constructor() {
    super();
  }
  /**
     * 接口跳转-POST请求
     * action_type     执行的类型
     * action_body     执行的参数
     */
  async produceData(pobj, req) {
    if (!pobj.actionBody) {
      return system.getResult(null, "actionBody不能为空");
    }
    var keyCount = Object.keys(pobj.actionBody).length;
    if (keyCount === 0) {
      return system.getResult(null, "actionBody参数不能为空");
    }
    if (!pobj.actionBody.pushUrl) {
      return system.getResult(null, "actionBody.pushUrl参数不能为空");
    }
    if (!pobj.actionBody.identifyCode) {
      return system.getResult(null, "actionBody.identifyCode参数不能为空");
    }
    if (!pobj.actionBody.messageBody) {
      return system.getResult(null, "actionBody.messageBody不能为空");
    }
    var msgKeyCount = Object.keys(pobj.actionBody.messageBody).length;
    if (msgKeyCount === 0) {
      return system.getResult(null, "actionBody.messageBody参数不能为空");
    }
    await this.redisClient.lpushData(settings.queuedName, pobj.actionBody);
    return system.getResultSuccess();
  }
  /**
   * 接口跳转-POST请求
   * action_type     执行的类型
   * action_body     执行的参数
   */
  async produceLogsData(pobj, req) {
    if (!pobj.actionBody) {
      return system.getResult(null, "actionBody不能为空");
    }
    var keyCount = Object.keys(pobj.actionBody).length;
    if (keyCount === 0) {
      return system.getResult(null, "actionBody参数不能为空");
    }
    if (!pobj.actionBody.identifyCode) {
      return system.getResult(null, "actionBody.identifyCode参数不能为空");
    }
    if (!pobj.actionBody.messageBody) {
      return system.getResult(null, "actionBody.messageBody不能为空");
    }
    var msgKeyCount = Object.keys(pobj.actionBody.messageBody).length;
    if (msgKeyCount === 0) {
      return system.getResult(null, "actionBody.messageBody参数不能为空");
    }
    await this.redisClient.lpushData(settings.queuedName, pobj.actionBody);
    return system.getResultSuccess();
  }
}
module.exports = UtilsProduceService;
