const system = require("../../../system");
const AppServiceBase = require("../../app.base");
const { TXCOSCONFIG } = require("../../../../config/platform");
const COSSTS = require('qcloud-cos-sts');
//用户权限操作
class UtilsTxCosService extends AppServiceBase {
  constructor() {
    super();
    this.configInfoDao = system.getObject("db.opLogs.configInfoDao");
  }
  /**
     * 接口跳转-POST请求
     * action_type     执行的类型
     * action_body     执行的参数
     */
  async getCosInfo() {
    var result = null;

    if (TXCOSCONFIG.allowPrefix === '_ALLOW_DIR_/*') {
      result = system.getResult(null, "请修改 allowPrefix 配置项，指定允许上传的路径前缀");
      return result;
    }
    var configInfoResult = await this.configInfoDao.getList();
    if (configInfoResult.status != 1) {
      result = system.getResult(null, "db-configInfo list is empty");
      return result;
    }
    var cosSecretId = configInfoResult.data.filter(f => f.c_key === "cosSecretId");
    var cosSecretKey = configInfoResult.data.filter(f => f.c_key === "cosSecretKey");
    var cosBucket = configInfoResult.data.filter(f => f.c_key === "cosBucket");
    var cosRegion = configInfoResult.data.filter(f => f.c_key === "cosRegion");
    var cosProxy = configInfoResult.data.filter(f => f.c_key === "cosProxy");
    if (!cosSecretId || !cosSecretKey || !cosBucket || !cosRegion) {
      result = system.getResult(null, "db-configInfo,cos info is empty");
      return result;
    }
    // 获取临时密钥
    var LongBucketName = cosBucket[0].c_value;
    var ShortBucketName = LongBucketName.substr(0, LongBucketName.lastIndexOf('-'));
    var AppId = LongBucketName.substr(LongBucketName.lastIndexOf('-') + 1);
    var policy = {
      'version': '2.0',
      'statement': [{
        'action': TXCOSCONFIG.allowActions,
        'effect': 'allow',
        'resource': [
          'qcs::cos:' + cosRegion[0].c_value + ':uid/' + AppId + ':prefix//' + AppId + '/' + ShortBucketName + '/' + TXCOSCONFIG.allowPrefix,
        ],
      }],
    };
    var options = {
      secretId: cosSecretId[0].c_value,
      secretKey: cosSecretKey[0].c_value,
      proxy: cosProxy ? cosProxy[0].c_value || "" : "",
      region: cosRegion[0].c_value,
      durationSeconds: TXCOSCONFIG.durationSeconds,
      policy: policy,
    };
    console.log(options, "...getCosInfo.....options");
    var getParam = await new Promise(function (resv, rej) {
      COSSTS.getCredential(options, function (err, tempKeys) {
        if (err) {
          rej(err);
        } else {
          if (tempKeys.credentials) {
            tempKeys.credentials.tmpBucket = cosBucket[0].c_value;
            tempKeys.credentials.tmpRegion = cosRegion[0].c_value;
          }
          resv(tempKeys);
        }
      });
    });
    result = getParam ? system.getResultSuccess(getParam) : system.getResult(null, "获取cos信息失败");
    return result;
  }
}
module.exports = UtilsTxCosService;
