const system = require("../system");
const settings = require("../../config/settings");
const moment = require('moment');
const axios = require('axios');
class EsUtils {
    constructor() {
        this.execClient = system.getObject("util.execClient");
        this.errorLogDao = system.getObject("db.opLogs.errorLogDao");
        this.configInfoDao = system.getObject("db.opLogs.configInfoDao");
    }

    /**
     * 添加es日志
     * @param {*} queuedName 队列名称
     * @param {*} actionBody 日志信息
     */
    async addEsLogs(queuedName, actionBody) {
        var esIndexName = queuedName + (actionBody.identifyCode ? "-" + actionBody.identifyCode : "");
        esIndexName = esIndexName.toLocaleLowerCase() + "/_doc?pretty";
        actionBody.resultInfo = typeof actionBody.resultInfo === 'object' ? JSON.stringify(actionBody.resultInfo) : actionBody.resultInfo;
        actionBody.errorInfo = typeof actionBody.errorInfo === 'object' ? JSON.stringify(actionBody.errorInfo) : actionBody.errorInfo;
        var params = {
            opTitle: moment().format("YYYY-MM-DD HH:mm:ss:SSS") + "，" + actionBody.opTitle || "",
            identifyCode: actionBody.identifyCode || "",
            messageBody: actionBody.messageBody || "",
            resultInfo: actionBody.resultInfo || "",
            errorInfo: actionBody.errorInfo || "",
            requestId: actionBody.requestId
        }
        var execResult = await this.execPostEs(queuedName, params, esIndexName);
        return execResult;
    }

    /**
     * post日志到Es
     * @param {*} queuedName 队列名称
     * @param {*} params 参数
     * @param {*} esIndexName es索引名称
     */
    async execPostEs(queuedName, params, esIndexName) {
        try {
            var configInfoResult = await this.configInfoDao.getList();
            if (configInfoResult.status != 1) {
                this.errorLogDao.addOpErrorLogs("publicLogsConsumer,configInfo list is empty", actionBody, null, null, 1);
                return system.getResultSuccess();
            }
            var publicLogsEsName = configInfoResult.data.filter(f => f.c_key === "publicLogsEsName");
            var publicLogsEsPwd = configInfoResult.data.filter(f => f.c_key === "publicLogsEsPwd");
            var publicLogsEsReqUrl = configInfoResult.data.filter(f => f.c_key === "publicLogsEsReqUrl");
            if (!publicLogsEsName || !publicLogsEsPwd || !publicLogsEsReqUrl) {
                this.errorLogDao.addOpErrorLogs("publicLogsConsumer,es account info is empty", actionBody, null, null, 1);
                return system.getResultSuccess();
            }
            var reqUrl = publicLogsEsReqUrl[0].c_value + esIndexName

            if (settings.env === "dev") {
                let result = await axios({
                    // headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    headers: {
                        'Content-type': 'application/json',
                        'Authorization': 'Basic YWRtaW5lczphZG1pbkdTQmVzLg=='
                    },
                    method: 'POST',
                    url: reqUrl,
                    data: JSON.stringify(params),
                    timeout: 5000
                });
                if (result.status == 201) {
                    return system.getResultSuccess();
                }
                this.errorLogDao.addOpErrorLogs(queuedName + "执行execPostEs存在错误", params, result, null, 3);
                return system.getResult(null, "执行execPostEs存在错误");
            }
            //方式二
            var result = await this.execClient.execPostEs(params, reqUrl, publicLogsEsName[0].c_value, publicLogsEsPwd[0].c_value);
            if (!result || !result.stdout) {
                this.errorLogDao.addOpErrorLogs(queuedName + "执行execPostEs存在错误", params, result, null, 3);
                return system.getResult(null, "执行execPostEs存在错误");
                return system.getResult(null, "execPostTimeOut data is empty");
            }
            var stdoutInfo = JSON.parse(result.stdout);
            if (stdoutInfo.error) {
                this.errorLogDao.addOpErrorLogs(queuedName + "执行execPostEs存在错误", params, result, null, 3);
                return system.getResult(null, "执行execPostEs存在错误");
            }
            return system.getResultSuccess(stdoutInfo);
        } catch (error) {
            console.log(error.stack, "......execPostEs....error.....");
            this.errorLogDao.addOpErrorLogs(queuedName + "执行execPostEs存在异常", params, null, error.stack, 3);
        }
    }
}

module.exports = EsUtils;
