var childproc = require('child_process');
const system = require("../system");
const util = require('util');
const exec = util.promisify(require('child_process').exec);
const settings = require("../../../app/config/settings");
const axios = require('axios');
class ExecClient {
    constructor() {
        this.cmdGetPattern = "curl -G -X GET '{url}'";
        this.cmdPostPattern = "curl -k -H 'Content-type: application/json' -d '{data}' {url}";
        // this.cmdPushDataPostPattern = "curl -k -H 'Content-type: application/json' -H 'token:{tk}' -H 'request-id:{requestId}' -d '{data}' {url}"; //--已废弃       
        this.errorLogDao = system.getObject("db.opLogs.errorLogDao");
    }
    /**
     * 带超时时间的post请求
     * @param {*} execFile 执行文件
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     * @param {*} timeOut 超时时间设置，单位秒
     */
    async execPostTimeOutByBusiness(execFile, params, url, ContentType, headData, timeOut = 5000) {
        var rtn = null;
        try {
            if (settings.env === "dev") {
                var headers = {
                    'Content-type': 'application/json'
                }
                if (headData) {
                    var headDataKeys = Object.keys(headData);
                    if (headDataKeys.length > 0) {
                        for (let index = 0; index < headDataKeys.length; index++) {
                            const indexKey = headDataKeys[index];
                            var headValue = headData[indexKey];
                            if (indexKey && headValue) {
                                headers[indexKey] = headValue;
                            }
                        }
                    }
                }
                axios.default.timeout = timeOut;
                let result = await axios({
                    // headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    headers: headers,
                    method: 'POST',
                    url: url,
                    data: JSON.stringify(params)
                });
                if (result.status == 200 && result.data) {
                    return result.data;
                }
                this.errorLogDao.addOpErrorLogs(queuedName + "执行execPostTimeOutByBusiness存在错误", params, result, null, 3);
                return system.getResult(null, "执行execPostTimeOutByBusiness存在错误");
            }
            //方式二
            rtn = await this.execPostTimeOut(params, url, ContentType, headData, timeOut);
            if (!rtn || !rtn.stdout) {
                return system.getResult(null, "execPostTimeOut data is empty");
            }
            var result = JSON.parse(rtn.stdout);
            return result;
        } catch (error) {
            this.errorLogDao.addOpErrorLogs(execFile + "执行execPostByTimeOut存在异常", params, rtn.stdout, error.stack, 3);
            return system.getResultFail(-200, execFile + "执行execPostByTimeOut存在异常");
        }
    }

    /**
     * get请求
     * @param {*} params 提交的数据-格式JSON
     * @param {*} url 
     * @param {*} headData  请求信息，JSON格式 
     */
    async execGet(params, url, headData) {
        let cmd = this.FetchGetCmd(params, url, headData);
        console.log(cmd);
        var result = await this.exec(cmd);
        return result;
    }
    /**
     * 
     * @param {*} params 提交的数据JSON格式
     * @param {*} url 
     * @param {*} headData  请求信息，JSON格式 
     * @param {*} timeOut 超时时间
     */
    async execGetTimeOut(params, url, headData, timeOut = 5000) {
        //timeOut，单位是毫秒
        let cmd = this.FetchGetCmd(params, url, headData);
        var options = {
            timeout: timeOut,
        };
        const { stdout, stderr } = await exec(cmd, options);
        return { stdout, stderr };
    }
    /**
     * 带超时时间的post请求
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     */
    async execPost(params, url, ContentType, headData) {
        let cmd = this.FetchPostCmd(params, url, ContentType, headData);
        var options = {
            maxBuffer: 1024 * 1024 * 15
        };
        var result = await this.exec(cmd, options, headData);
        return result;
    }
    /**
     * 带超时时间的post请求
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     * @param {*} timeOut 超时时间设置，单位秒
     */
    async execPostTimeOut(params, url, ContentType, headData, timeOut = 5000) {
        let cmd = this.FetchPostCmd(params, url, ContentType, headData);
        var options = {
            timeout: timeOut,
            maxBuffer: 1024 * 1024 * 15
        };
        var result = await this.exec(cmd, options);
        return result;
    }
    /**
     * post日志到Es
     * @param {*} params 参数
     * @param {*} reqUrl 
     * @param {*} esName 
     * @param {*} esPwd 
     */
    async execPostEs(params, reqUrl, esName, esPwd) {
        let cmd = this.FetchPostEsCmd(params, reqUrl, esName, esPwd);
        var result = await this.exec(cmd);
        return result;
    }

    //--------------------------------------------------辅助方法start-----------------

    async exec(cmd) {
        //await后面表达式返回的promise对象，是then的语法糖，await返回then函数的返回值
        //异常需要try/catch自己捕获或外部catch捕获
        const { stdout, stderr } = await exec(cmd);
        return { stdout, stderr };
    }
    FetchGetCmd(params, url, headData) {
        var cmd = this.cmdGetPattern.replace(
            /\{data\}/g, params).replace(/\{url\}/g, url);
        console.log(cmd);
        return cmd;
    }
    FetchPostCmd(params, url, ContentType, headData) {
        if (!ContentType) {
            ContentType = "application/json";
        }
        var data = typeof params === 'object' ? JSON.stringify(params) : params;

        var cmdStr = "curl -k -H 'Content-type:" + ContentType + "'";
        if (headData) {
            var headDataKeys = Object.keys(headData);
            if (headDataKeys.length > 0) {
                for (let index = 0; index < headDataKeys.length; index++) {
                    const indexKey = headDataKeys[index];
                    var headValue = headData[indexKey];
                    if (indexKey && headValue) {
                        cmdStr = cmdStr + " -H '" + indexKey + ":" + headValue + "'";
                    }
                }
            }
        }
        cmdStr = cmdStr + " -d '" + data + "' " + url;
        console.log(cmdStr, "：cmdStr.................");
        return cmdStr;
    }
    FetchPostEsCmd(params, reqUrl, esName, esPwd) {
        var data = JSON.stringify(params);
        var cmdStr = "curl --user " + esName + ":" + esPwd + " -k -H 'Content-type: application/json' -d '" + data + "' " + reqUrl;
        console.log(cmdStr, "：cmdStr.................");
        return cmdStr;
    }

    //--------------------------------------------------辅助方法end-----------------
}

module.exports = ExecClient;
