var path = require('path');
var ENVINPUT = {
  DB_HOST: process.env.DB_HOST,
  DB_PORT: process.env.DB_PORT,
  DB_USER: process.env.DB_USER,
  DB_PWD: process.env.DB_PWD,
  REDIS_HOST: process.env.REDIS_HOST,
  REDIS_PORT: process.env.REDIS_PORT,
  REDIS_PWD: process.env.REDIS_PWD,
  REDIS_DB: process.env.QUEUE_REDIS_DB,
  DB_NAME: process.env.QUEUE_DB_NAME,
  APP_ENV: process.env.APP_ENV ? process.env.APP_ENV : "test",//运行环境
  CONSUMER_NAME: process.env.CONSUMER_NAME || "publicServiceAllocation.publicConsumer",//消费者名称
  QUEUED_NAME: process.env.QUEUED_NAME || "SYTXPUBLIC-MSGQ",//队列名称，FAIL-失败队列（队列和失败队列一对存在进行部署）
};
var settings = {
  env: ENVINPUT.APP_ENV,
  consumerName: ENVINPUT.CONSUMER_NAME,
  queuedName: ENVINPUT.QUEUED_NAME,
  basepath: path.normalize(path.join(__dirname, '../..')),
  port: process.env.NODE_PORT || 4018,
  redis: function () {
    if (this.env == "dev" || this.env == "test") {
      var localsettings = require("./localsettings");
      return localsettings.redis;
    } else {
      return {
        host: ENVINPUT.REDIS_HOST,
        port: ENVINPUT.REDIS_PORT,
        password: ENVINPUT.REDIS_PWD,
        db: ENVINPUT.REDIS_DB,
      };
    }
  },
  database: function () {
    if (this.env == "dev" || this.env == "test") {
      var localsettings = require("./localsettings");
      return localsettings.database;
    } else {
      return {
        dbname: ENVINPUT.DB_NAME,
        user: ENVINPUT.DB_USER,
        password: ENVINPUT.DB_PWD,
        config: {
          host: ENVINPUT.DB_HOST,
          dialect: 'mysql',
          operatorsAliases: false,
          pool: {
            max: 5,
            min: 0,
            acquire: 90000000,
            idle: 1000000
          },
          debug: false,
          dialectOptions: {
            requestTimeout: 999999,
            // instanceName:'DEV'
          }  //设置MSSQL超时时间
        },
      };
    }
  }
};
settings.ENVINPUT = ENVINPUT;
module.exports = settings;
