var system = require("../../system")
const md5 = require("MD5");
const logCtl = system.getObject("web.oplogCtl");
var svgCaptcha = require('svg-captcha');
const uuidv4 = require('uuid/v4');

class EcontractApi {
  constructor() {
    this.redisClient = system.getObject("util.redisClient");
  }

  async randomkey() {
    return uuidv4();
  }

  async captcha(qobj) {
    var uuid = uuidv4();
    var key = uuid.replace(/\-/g,"");

    var options = {size : 4, noise : 1, ignoreChars: '0o1i'};
    options.width = qobj.width || 120;
    options.height = qobj.height || 32;
    options.background = qobj.background || "#E8E8E8";

    var redisKey = "captcha_" + key;
    var cap = svgCaptcha.create(options);
    await this.redisClient.setWithEx(redisKey, cap.text, 60);
    return system.getResult2({
      key : key,
      captcha : cap.data,
    });
  }
}
module.exports = EcontractApi;