const system = require("../../system");
const md5 = require("MD5");

class EntcontractApi {
    constructor() {
        this.entcontractSve = system.getObject("service.entcontractSve");
        this.ecompanybusiSve = system.getObject("service.ecompanybusiSve");
        this.idcardClient = system.getObject("util.idcardClient");
        this.utilesignbaoSve = system.getObject("service.utilesignbaoSve");
    }

    async syncSignedFile() {
        this.entcontractSve.downloadCompleteUrl();
        return "start success"
    }

    async autoSign(pobj) {
        // 处理参数
        var param = {
            ecid: this.trim(pobj.ecid),
            appId: this.trim(pobj.appId),
            userId: this.trim(pobj.userId),

            name: this.trim(pobj.firstName), //甲方 必填
            addr: this.trim(pobj.firstAddr), //甲方地址
            legal: this.trim(pobj.firstLegal),//甲方法定代表人
            contactName: this.trim(pobj.firstContactName),//甲方联系人
            contactMobile: this.trim(pobj.firstContactMobile),//甲方 联系电话

            idName: this.trim(pobj.idName),//姓名
            mobile: this.trim(pobj.mobile),//手机号
            idNo: this.trim(pobj.idNo),//身份证
            bankno: this.trim(pobj.bankno),//银行卡
            nonceStr: this.trim(pobj.nonceStr),//随机码
            sign: this.trim(pobj.sign)
        };

        if (!param.ecid) {
            return this.returnjson(-1, "请传入薪必果提供的ecid")
        }
        if (!param.appId) {
            return this.returnjson(-1, "请传入薪必果提供的appId")
        }
        if (!param.idName) {
            return this.returnjson(-1, "请提供该用户姓名")
        }
        if (!param.idNo) {
            return this.returnjson(-1, "请提供该用户身份证号")
        } else {
            if (!await this.idcardClient.checkIDCard(param.idNo)) {
                return this.returnjson(-1, "身份证格式不正确");
            }
        }
        if (!param.bankno) {
            return this.returnjson(-1, "请提供该用户银行卡号")
        }
        if (!param.nonceStr) {
            return this.returnjson(-1, "请提供随机码")
        }

        // 查appId关联key
        var busi = await this.ecompanybusiSve.findOne({
            appId: param.appId
        });
        if (!busi || !busi.key) {
            return this.returnjson(1001003, "配置信息错误，请联系薪必果人员进行配置");
        }

        // 签名
        var signArr = [];
        var keys = Object.keys(param).sort();
        for (var i = 0; i < keys.length; i++) {
            var k = keys[i];
            var v = param[k];
            if (!k || !v || k == 'sign') {
                continue;
            }
            signArr.push(k + "=" + v);
        }
        var signStr = signArr.join("&") + "&key=" + busi.key;
        var sign = md5(signStr).toUpperCase();
        if (param.sign != sign) {
            return this.returnjson(1001001, "签名错误");
        }
        try {
            param.idNo = param.idNo.toUpperCase();
            var result = await this.entcontractSve.autoSign(param);
            return result;
        } catch (error) {
            console.log(error);
        }
    }

    async autoSignToPer(pobj) {
        // 处理参数
        var param = {
            ecid: this.trim(pobj.ecid),
            appId: this.trim(pobj.appId),
            userId: this.trim(pobj.userId),
            idName: this.trim(pobj.idName),
            mobile: this.trim(pobj.mobile),
            idNo: this.trim(pobj.idNo),
            nonceStr: this.trim(pobj.nonceStr),
            sign: this.trim(pobj.sign)
        };

        if (!param.ecid) {
            return this.returnjson(-1, "请传入薪必果提供的ecid")
        }
        if (!param.appId) {
            return this.returnjson(-1, "请传入薪必果提供的appId")
        }
        if (!param.userId) {
            return this.returnjson(-1, "请提供该用户的userId")
        }
        if (!param.idName) {
            return this.returnjson(-1, "请提供该用户姓名")
        }
        if (!param.idNo) {
            return this.returnjson(-1, "请提供该用户身份证号")
        } else {
            if (!await this.idcardClient.checkIDCard(param.idNo)) {
                return this.returnjson(-1, "身份证格式不正确");
            }
            // let card = await this.idcardClient.cardInfo(param.idNo);
            // let age = card.age || 0;
            // if (!age) {
            //     return this.returnjson(-1, "身份证号格式错误, 只支持18位身份证号码");
            // }
            // if (card.sex == 'male') {
            //     if (age < 18 || age > 60) {
            //         return this.returnjson(-1, "签约失败，男限制18-60岁之间")
            //     }
            // } else {
            //     if (age < 18 || age > 55) {
            //         return this.returnjson(-1, "签约失败，女限制18-55岁之间")
            //     }
            // }
        }
        if (!param.nonceStr) {
            return this.returnjson(-1, "请提供随机码")
        }

        // 查appId关联key
        var busi = await this.ecompanybusiSve.findOne({
            appId: param.appId
        });
        if (!busi || !busi.key) {
            return this.returnjson(1001003, "配置信息错误，请联系薪必果人员进行配置");
        }

        // 签名
        var signArr = [];
        var keys = Object.keys(param).sort();
        for (var i = 0; i < keys.length; i++) {
            var k = keys[i];
            var v = param[k];
            if (!k || !v || k == 'sign') {
                continue;
            }
            signArr.push(k + "=" + v);
        }
        var signStr = signArr.join("&") + "&key=" + busi.key;
        var sign = md5(signStr).toUpperCase();
        console.log(sign)
        if (param.sign != sign) {
            return this.returnjson(1001001, "签名错误");
        }

        try {
            param.idNo = param.idNo.toUpperCase();
            var result = await this.entcontractSve.autoSignToPer(param);
            return result;
        } catch (error) {
            console.log(error);
        }
    }


    async sinedUsers3rd(obj, req) {
        // 验证合法性
        var appId = obj.appId;
        var nonceStr = obj.nonceStr;
        var idNo = obj.idNo;
        var startId = obj.startId || 0;
        var userId = obj.userId || "";
        var pageSize = 20;

        var busi = await this.ecompanybusiSve.findOne({
            appId: appId
        });
        if (!busi) {
            return {
                code: 1001003,
                msg: "配置信息错误，请联系薪必果人员进行配置"
            };
        }

        var signArr = [];
        signArr.push("appId=" + appId);
        signArr.push("idNo=" + idNo);
        signArr.push("nonceStr=" + nonceStr);
        signArr.push("startId=" + startId);
        signArr.push("userId=" + userId);
        signArr.push("key=" + busi.key);

        var sign = md5(signArr.join("&")).toUpperCase();
        if (sign != obj.sign) {
            return {
                code: 1001001,
                msg: "签名失败"
            };
        }
        var params = {
            entcompanyId: busi.ecompany_id,
            startId: startId,
            idNo: idNo.toUpperCase(),
            pageSize: pageSize,
            userId3rd: userId,
        };

        try {
            var userList = await this.entcontractSve.findSignedUses4Push(params);

            var result = {
                code: 0,
                msg: "success",
            };
            result.data = userList;
            return result;
        } catch (e) {
            var result = {
                code: 500,
                msg: "接口异常"
            };
            console.log(e.stack);
            //日志记录
            logCtl.error({
                optitle: "校验是否签约error",
                op: "api/econtractApi/validContract",
                content: e.stack,
                clientIp: req.clientIp
            });
            return result;
        }
    }

    trim(o) {
        if (!o) {
            return "";
        }
        return o.toString().trim();
    }

    returnjson(code, msg, data) {
        return {
            code: code,
            msg: msg,
            data: data || null
        }
    }


}

module.exports = EntcontractApi;
