var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const moment = require('moment');
class EcompanyeventCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(EcompanyeventCtl));
  }

  async handingList(queryobj, qobj, req) {
    var ecompany = req.session.ecompany;
    if (!ecompany) {
      return system.getResult2({count: 0});
    }

    try {
      var params = {
        ecompany_id: ecompany.id,
        statusFlag: '2'
      };
      var rs = await this.service.getList(params, qobj.currentPage || 1, qobj.pageSize || 5);

      if (rs && rs.rows) {
        for (var row of rs.rows) {
          if (row.created_at) {
            row.created_at = moment(row.created_at).format("YYYY-MM-DD HH:mm:ss");
          }
        }
      }
      return system.getResult2(rs);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async adminHandingList(queryobj, qobj, req) {
    try {
      var params = {
        ecompany_id: -1,
        statusFlag: '2'
      };
      var rs = await this.service.getList(params, qobj.currentPage || 1, qobj.pageSize || 5);
      if (rs && rs.rows) {
        for (var row of rs.rows) {
          if (row.created_at) {
            row.created_at = moment(row.created_at).format("YYYY-MM-DD HH:mm:ss");
          }
        }
      }
      return system.getResult2(rs);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }
}
module.exports = EcompanyeventCtl;