var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class EintentionfollowCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(EintentionfollowCtl));

  }

  async addFollow(queryobj, qobj, req) {

    var follow = {
      eintention_id: qobj.eintention_id,
      followUserId: req.session.user.id,
      followUserName: req.session.user.nickName,
      followStatus: qobj.followStatus,
      followStatusName: qobj.followStatusName,
      content: qobj.content, 
    };

    try {
      await this.service.create(follow);
      return system.getResult2(1);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async followList(queryobj, qobj, req) {
    var params = qobj.search || {};
      if(!params.eintention_id) {
      return system.getResult2({total:0, rows:[]});
    }

    try {
      var page = await this.service.pageByCondition(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }
}
module.exports = EintentionfollowCtl;