var system = require("../../system")
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
const moment = require("moment");
class EjobCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(EjobCtl));
    this.ejobapplySve = system.getObject("service.ejobapplySve");
    this.esettleSve = system.getObject("service.esettleSve");
    this.ecompanySve = system.getObject("service.ecompanySve");

  }

  async jobInfo(queryobj, qobj, req) {
    try {
      var jobInfo = await this.service.jobDetail(qobj.jobId, qobj.pattern || {});
      return system.getResult2(jobInfo);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async saveJob(queryobj, qobj, req) {
    var user = req.session.user;
    var ecompany = await this.ecompanySve.findOne({user_id : user.id});
    if(!ecompany) {
      return system.getErrResult2("您的企业未认证通过, 请先做企业认证再发布需求");
    }

    if(ecompany.jdAuthStatus != '1') {
      return system.getErrResult2("您的企业未认证通过, 请耐心等待通过后再发布需求");
    }
    try {
      qobj.ejob.ecompany_id = ecompany.id;
      var rs = await this.service.saveJob(qobj.ejob);
      if(rs.msg) {
        return system.getErrResult2(rs.msg);
      }
      return system.getResult2(rs.ejob);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async companyJobs(queryobj, qobj, req) {
    var ecompany = req.session.ecompany;
    if(!ecompany) {
      return system.getResult2({count:0, rows:[]});
    }

    var params = qobj.search;
    this.doTimeCondition(params, ["applyBegin", "applyEnd", "publishBegin", "publishEnd", "rejectBegin", "rejectEnd", "cancelBegin", "cancelEnd"]);
    params.ecompanyId = ecompany.id;
    try {
      var page = await this.service.jobPage(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    } 
  }

  async allJobs(queryobj, qobj, req) {
    var params = qobj.search;
    this.doTimeCondition(params, ["applyBegin", "applyEnd", "publishBegin", "publishEnd", "rejectBegin", "rejectEnd", "cancelBegin", "cancelEnd"]);
    try {
      var page = await this.service.jobPage(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    } 
  }

  async statSQXQL(queryobj, qobj, req) {
    var ecompany = req.session.ecompany;
    if(!ecompany) {
      return system.getResult2({count:0});
    }
    var params = this.getTimes(qobj.statTime || "");
    
    try {
      params.ecompany_id = ecompany.id;
      var count = await this.service.stat(params);
      return system.getResult2({count:count});
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }
  async statAllSQXQL(queryobj, qobj, req) {
    var params = this.getTimes(qobj.statTime || "");
    try {
      var count = await this.service.stat(params);
      return system.getResult2({count:count});
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }


  async statFDL(queryobj, qobj, req) {
    var ecompany = req.session.ecompany;
    if(!ecompany) {
      return system.getResult2({count:0});
    }
    var params = this.getTimes(qobj.statTime || "");
    
    try {
      params.ecompany_id = ecompany.id;
      params.jobStatuses = ['1'];
      var count = await this.service.stat(params);
      return system.getResult2({count:count});
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async statAllFDL(queryobj, qobj, req) {
    var params = this.getTimes(qobj.statTime || "");

    try {
      params.jobStatuses = ['1'];
      var count = await this.service.stat(params);
      return system.getResult2({count:count});
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async statJDL(queryobj, qobj, req) {
    var ecompany = req.session.ecompany;
    if(!ecompany) {
      return system.getResult2({count:0});
    }
    var params = this.getTimes(qobj.statTime || "");
    
    try {
      params.ecompany_id = ecompany.id;
      var count = await this.ejobapplySve.stat(params);
      return system.getResult2({count:count});
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async statAllJDL(queryobj, qobj, req) {
    var params = this.getTimes(qobj.statTime || "");
    try {
      var count = await this.ejobapplySve.stat(params);
      return system.getResult2({count:count});
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async statCGQYL(queryobj, qobj, req) {
    var ecompany = req.session.ecompany;
    if(!ecompany) {
      return system.getResult2({count:0});
    }
    var params = this.getTimes(qobj.statTime || "");
    
    try {
      params.ecompany_id = ecompany.id;
      params.statuses = ['2','3','4'];
      var count = await this.ejobapplySve.stat(params);
      return system.getResult2({count:count});
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async statAllCGQYL(queryobj, qobj, req) {
    var params = this.getTimes(qobj.statTime || "");
    try {
      params.statuses = ['2','3','4'];
      var count = await this.ejobapplySve.stat(params);
      return system.getResult2({count:count});
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async statJYZE(queryobj, qobj, req) {
    var ecompany = req.session.ecompany;
    if(!ecompany) {
      return system.getResult2({count:0});
    }
    var params = this.getTimes(qobj.statTime || "");
    
    try {
      params.ecompany_name = ecompany.name;
      var count = await this.esettleSve.statSettle(params);
      if(count) {
        count = parseFloat((count / 100).toFixed(2));
      }
      return system.getResult2({count:count});
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async statAllJYZE(queryobj, qobj, req) {
    var params = this.getTimes(qobj.statTime || "");
    
    try {
      var count = await this.esettleSve.statSettle(params);
      if(count) {
        count = parseFloat((count / 100).toFixed(2));
      }
      return system.getResult2({count:count});
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async jobCancel(queryobj, qobj, req) {

    try {
      var user = req.session.user;
      if (!user) {
        return system.getErrResult2('登录状态过期, 请刷新页面重新登录');
      }
      var jobId = Number(qobj.jobId);
      var job = await this.service.findById(jobId);
      if (!job) {
        return system.getErrResult2('零工不存在');
      }
  
      if(job.jobStatus != '0') {
        return system.getErrResult2('撤销失败, 零工' + job.jobStatusName);
      }
  
      job.jobStatus = '3';
      job.jobStatusName = '已撤销';
      job.cancel_at = new Date();
      await job.save();
      return system.getResult2(1);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async audit(queryobj, qobj, req) {
    try {
      var user = req.session.user;
      if (!user) {
        return system.getErrResult2('登录状态过期, 请刷新页面重新登录');
      }

      var jobId = Number(qobj.jobId);
      var rs = await this.service.audit(jobId, qobj.auditStatus, this.trim(qobj.auditRemark), user.id);
      if(rs == -1) {
        return system.getErrResult2("需求不存在");
      }

      if(rs == -2) {
        return system.getErrResult2("审核失败, 需求已被审核");
      }

      if(rs == -3) {
        return system.getErrResult2("请填写驳回原因");
      }
      return system.getResult2(1);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }


  getTimes(statTime) {
    var begin;
    var end;
    if(statTime == '1') {
      begin = moment().year(moment().year()).startOf('year').format("YYYY-MM-DD") + " 00:00:00";
      end = moment().year(moment().year()).endOf('year').format("YYYY-MM-DD") + " 23:59:59";
    } else if(statTime == '2') {
      begin = moment().quarter(moment().quarter()).startOf('quarter').format("YYYY-MM-DD") + " 00:00:00";
      end = moment().quarter(moment().quarter()).endOf('quarter').format("YYYY-MM-DD") + " 23:59:59";
    } else if(statTime == '3') {
      begin = moment().month(moment().month()).startOf('month').format("YYYY-MM-DD") + " 00:00:00";
      end = moment().month(moment().month()).endOf('month').format("YYYY-MM-DD") + " 23:59:59";
    } else {
    }
    return {begin:begin || "", end:end || ""}
  }
}
module.exports = EjobCtl;