var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');

class EjobapplyCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(EjobapplyCtl));
     //this.appS=system.getObject("service.appSve");

   }
   
   async jobApplys(queryobj, qobj, req) {
    var jobId = qobj.jobId;
    if(!jobId) {
      return system.getResult2({count:0, rows:[]});
    }

    var ecompany = req.session.ecompany;
    if(!ecompany) {
      return system.getResult2({count:0, rows:[]});
    }

    var params = qobj.search || {};
    params.ejob_id = jobId;
    params.ecompany_id = ecompany.id;

    this.doTimeCondition(params, ["applyBegin", "applyEnd", "signBegin", "signEnd", "auditBegin", "auditEnd", "cancelBegin", "cancelEnd"]);
    try {
      var page = await this.service.pageByCondition(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    } 
  }


  async jobAllApplys(queryobj, qobj, req) {
    var jobId = qobj.jobId;
    if(!jobId) {
      return system.getResult2({count:0, rows:[]});
    }

    var params = qobj.search || {};
    params.ejob_id = jobId;

    this.doTimeCondition(params, ["applyBegin", "applyEnd", "signBegin", "signEnd", "auditBegin", "auditEnd", "cancelBegin", "cancelEnd"]);
    try {
      var page = await this.service.pageByCondition(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    } 
  }

  async companyApplys(queryobj, qobj, req) {
    var ecompany = req.session.ecompany;
    if(!ecompany) {
      return system.getResult2({count:0, rows:[]});
    }

    var params = qobj.search || {};
    params.needJob = true;
    params.ecompany_id = ecompany.id;
    // params.applyStatuses = ['2', '3', '4'];

    try {
      var page = await this.service.pageUserByCondition(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async allApplys(queryobj, qobj, req) {
    var ecompany = req.session.ecompany;
    if(!ecompany) {
      return system.getResult2({count:0, rows:[]});
    }

    var params = qobj.search || {};
    params.needJob = true;
    // params.applyStatuses = ['2', '3', '4'];

    try {
      var page = await this.service.pageUserByCondition(params);
      return system.getResult2(page);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    } 
  }

  async applyInfo(queryobj, qobj, req) {
    var id = qobj.id;
    if(!id) {
      return system.getErrResult2("零工申请不存在");
    }
    try {
      var info = await this.service.info(id);
      return system.getResult2(info);
    } catch (e) {
      console.log(e);
      return system.getErrResult2("您的网络不稳, 请稍后重试");
    }
  }

  async notifyInterview(queryobj, qobj, req) {
    var ids = qobj.ids || [];

    if(ids.length == 0) {
      return system.getResult2(1);
    }
    for(var id of ids) {
      try {
        var rs = await this.service.notifyInterView(id, qobj.interviewTime);
        console.log("notifyInterview  id[" + id + "], rs[" + rs + "] ");
      } catch (e) {
        console.log(e);
      }
    }
    return system.getResult2(1);
  }
  
  async audit(queryobj, qobj, req) {
    var ids = qobj.ids || []; 

    if(ids.length == 0) {
      return system.getResult2(1);
    }
    for(var id of ids) {
      try {
        var rs = await this.service.audit(id, this.trim(qobj.auditStatus), this.trim(qobj.auditRemark));
        console.log("notifyInterview  id[" + id + "], rs[" + rs + "] ");
      } catch (e) {
        console.log(e);
      }
    }
    return system.getResult2(1);
  }
}
module.exports=EjobapplyCtl;
