const CacheBase = require("../cache.base");
const system = require("../../system");

class AppletUserinfoCache extends CacheBase {
    constructor() {
        super();
        this.userDao = system.getObject("db.userDao");
        this.globalKeyPrefix = "applet_userinfo";
    }
    async del(openid, appid) {
        var key = (appid || this.globalKeyPrefix) + "_" + openid;
        await this.redisClient.delete(key);
    }
    async set(openid, value, appid) {
        var key = (appid || this.globalKeyPrefix) + "_"  + openid;
        this.redisClient.set(key, value);
        return key;
    }
    async get(openid, appid) {
        var key = (appid || this.globalKeyPrefix) + "_"  + openid;
        const value = await this.redisClient.get(key);
        if (value) {
            return value;
        } else {
            var user = await this.userDao.getUserByOpenId(openid);
            user = JSON.stringify(user);
            if (user != null && user != "") {
                await this.redisClient.set(key, user);
                return user;
            } else {
                return null;
            }
        }
    }
}
module.exports = AppletUserinfoCache;