const system=require("../../system");
const Dao=require("../dao.base");
const moment = require("moment");
class EjobcollectDao extends Dao{
  constructor(){
    super(Dao.getModelName(EjobcollectDao));
  }

  async findMapByJobIds(jobIds) {
    var result = [];
    if(!jobIds || jobIds.length == 0) {
      return result;
    }

    var sql = "SELECT * FROM c_ejob_collect where ejob_id IN (:jobIds) ";
    var list = await this.customQuery(sql, {jobIds:jobIds});
    if(!list || list.length == 0) {
      return result;
    }

    for(var item of list) {
      var key = "ejobId_" + item.ejob_id;
      var lst = result[key];
      if(!lst) {
        lst = [];
      }
      lst.push(item);
      result[key] = lst;
    }
    return result;
  }
}
module.exports=EjobcollectDao;
