const system = require("../../system");
const Dao = require("../dao.base");
class EpartnerDao extends Dao {
  constructor() {
    super(Dao.getModelName(EpartnerDao));
  }

  extraWhere(obj,w){
    //如果是我的客户
    if(obj.sourceIds) {
      w["sourceId"] = {
        [this.db.Op.in]: obj.sourceIds
      };
    }
    return w;
  }

  async suggest(name) {
    if(!name) {
      return [];
    }
    var sql = "SELECT id, nickName, userName, mobile FROM `c_epartner` WHERE user_id > 0 AND ( nickName LIKE :queryLike OR userName LIKE :queryLike OR mobile LIKE :queryLike) ORDER BY id ASC ";
    var list = await this.customQuery(sql, {queryLike: "%" + name + "%"});
    return list || [];
  }
}
module.exports = EpartnerDao;