const system=require("../../system");
const Dao=require("../dao.base");
class EtemplateDao extends Dao{
  constructor(){
    super(Dao.getModelName(EtemplateDao));
  }

  extraModelFilter(){
    //return {"key":"include","value":[{model:this.db.models.app,},{model:this.db.models.role,as:"Roles",attributes:["id","name"],joinTableAttributes:['created_at']}]};
    return {"key":"include","value":[{model:this.db.models.ecompany,attributes:["id","name"]}]};
  }

  async getListByName(name) {
    if(!name) {
      return [];
    }
    var sql = "SELECT id, name FROM `c_etemplate` WHERE name LIKE :queryLike AND deleted_at IS NULL ";
    sql = sql + " ORDER BY id ASC ";
    var list = await this.customQuery(sql, {queryLike: "%" + name + "%"});
    return list || [];
  }

  async findMapByIds(ids, attrs) {
    var result = {};
    if(!ids || ids.length == 0) {
      return result;
    }

    attrs = attrs || "*";
    var sql = "SELECT " + attrs + " FROM c_etemplate where id IN (:ids) ";
    var list = await this.customQuery(sql, {ids:ids});
    if(!list || list.length == 0) {
      return result;
    }

    for(var item of list) {
      result[item.id] = item;
    }

    return result;
  }
}
module.exports=EtemplateDao;
