const system = require("../../system");
const Dao = require("../dao.base");

class LDUserDao extends Dao {
  constructor() {
    super(Dao.getModelName(LDUserDao));
  }

  async updateBalance(id, amt) {
    let sql = `UPDATE ${this.model.tableName} SET p_user_balance = p_user_balance + :amt WHERE id = :id AND p_user_balance + :amt >= 0`;
    let rs = await this.customUpdate(sql, {id: id, amt: amt});
    return rs;
  }
}

module.exports = LDUserDao;
