const system=require("../../system");
const Dao=require("../dao.base");
class UsereaccountDao extends Dao{
  constructor(){
    super(Dao.getModelName(UsereaccountDao));
  }

  async getById(id) {
    return await this.model.findOne({where:{id:id}, raw: true});
  }

  async idsByCondition(condition) {
    var result = [];
    var params = {};
    var sql = "SELECT id FROM p_user_eaccount WHERE 1 = 1 ";

    if(condition.ids) {
      sql = sql + " AND id IN (:ids) ";
      params.ids = condition.ids;
    }

    if(condition.userName) {
      sql = sql + " AND userName LIKE :userName ";
      params.userName =  "%" + condition.userName + "%";
    }
    if(condition.mobile) {
      sql = sql + " AND mobile LIKE :mobile ";
      params.mobile =  "%" + condition.mobile + "%";
    }
    if(condition.personsSign) {
      sql = sql + " AND personsSign = :personsSign ";
      params.personsSign = condition.personsSign;
    }

    if(condition.identityType) {
      sql = sql + " AND identity = :identity ";
      params.identity = condition.identityType;
    }
    if(condition.sex) {
      sql = sql + " AND sex = :sex ";
      params.sex = condition.sex;
    }
    if(condition.edu) {
      sql = sql + " AND edu = :edu ";
      params.edu = condition.edu;
    }
    if(condition.age) {
      sql = sql + " AND age = :age ";
      params.age = condition.age;
    }
    if(condition.height) {
      sql = sql + " AND height = :height ";
      params.height = condition.height;
    }
    sql = sql + " LIMIT 500 ";

    var list = await this.customQuery(sql, params);
    if(list) {
      for(var item of list) {
        result.push(item.id);
      }
    }
    return result;
  }


  async findMapByIds(ids, attrs) {
    var result = [];
    if(!ids || ids.length == 0) {
      return result;
    }

    attrs = attrs || "*";
    var sql = "SELECT " + attrs + " FROM p_user_eaccount where id IN (:ids) ";
    var list = await this.customQuery(sql, {ids:ids});
    if(!list || list.length == 0) {
      return result;
    }

    for(var item of list) {
      result["id_" + item.id] = item;
    }

    return result;
  }

  
}
module.exports=UsereaccountDao;
