const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("ejob", {
    ecompany_id: DataTypes.INTEGER,
    name: DataTypes.STRING(50),
    num: DataTypes.INTEGER,
    limitnum: DataTypes.INTEGER,
    sexName: {
      type: DataTypes.STRING(20),
      defaultValue: "不限",
    },
    sex: {
      // 性别 ''不限 male男 female女
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.jobsex),
      set: function (val) {
        this.setDataValue("sex", val);
        this.setDataValue("sexName", uiconfig.config.pdict.jobsex[val]);
      },
      defaultValue: "",
    },

    settleTypeName: {
      type: DataTypes.STRING(10),
      defaultValue: "计时+计件",
    },
    settleType: {
      // 结算方式 0计时+计件 1计时 2计件
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.settleType),
      set: function (val) {
        this.setDataValue("settleType", val);
        this.setDataValue("settleTypeName", uiconfig.config.pdict.settleType[val]);
      },
      defaultValue: "0",
    },

    timeTypeName: {
      type: DataTypes.STRING(10),
      defaultValue: "",
    },
    timeType: {
      // 计时类型 0无 1元/时 2元/天 3元/月
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.timeType),
      set: function (val) {
        this.setDataValue("timeType", val);
        this.setDataValue("timeTypeName", uiconfig.config.pdict.timeType[val]);
      },
    },
    timeSalary: DataTypes.INTEGER,
    pieceSalary: DataTypes.INTEGER,
    salaryAvg: DataTypes.INTEGER,
    addr: DataTypes.STRING(200),
    jobStatusName: {
      type: DataTypes.STRING(20),
      defaultValue: "待审核",
    },
    jobStatus: {
      // 审核状态 0待审核 1已发布 2已驳回 3已撤销
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.jobStatus),
      set: function (val) {
        this.setDataValue("jobStatus", val);
        this.setDataValue("jobStatusName", uiconfig.config.pdict.jobStatus[val]);
      },
      defaultValue: "0",
    },

    audit_at: DataTypes.DATE,
    audit_id: DataTypes.INTEGER,
    auditRemark: DataTypes.STRING(200),
    publish_at: DataTypes.DATE,
    reject_at: DataTypes.DATE,
    cancel_at: DataTypes.DATE,
    intro: DataTypes.STRING(200),
    require: DataTypes.STRING(200),
    collectCount: DataTypes.INTEGER,
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'c_ejob',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}