const system = require("../../system");
const settings = require("../../../config/settings");
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
  return db.define("esettleoffline", {
    ecompany_id: DataTypes.INTEGER,
    ecompanyName: DataTypes.STRING(255),
    user_id: DataTypes.INTEGER,
    epartner_id: DataTypes.INTEGER,
    sourceType: DataTypes.INTEGER,
    month: DataTypes.INTEGER,
    pay_time: DataTypes.DATE,
    pay_complete_time: DataTypes.DATE,
    out_trade_no: DataTypes.STRING(32),
    tbl_order_id: DataTypes.STRING(32),
    busi_id: DataTypes.STRING(32),

    amt: DataTypes.BIGINT(20),
    actual_amt: DataTypes.BIGINT(20),
    deduct_amt: DataTypes.BIGINT(20),
    service_rate: DataTypes.DOUBLE(11, 2),
    service_tax: DataTypes.BIGINT(20),
    added_value_tax: DataTypes.BIGINT(20),

    open_bank: DataTypes.STRING(100),
    bankno: DataTypes.STRING(30),
    fileurl: DataTypes.STRING(300),
  }, {
    paranoid: true, //假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'c_esettle_offline',
    validate: {},
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}