const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
    return db.define("regionarea", {
        REGION_ID: {
            type: DataTypes.INTEGER,
            allowNull: false,
        },
        REGION_CODE: {
            type: DataTypes.STRING,
            allowNull: false,
        },//需要在后台补充
      
        REGION_NAME: {
            type: DataTypes.STRING,
            allowNull: false,
        },//需要在后台补充
        PARENT_CODE: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        REGION_LEVEL:{
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        usageType:{//用途类型
          type:DataTypes.ENUM,
          allowNull: false,
          values: Object.keys(uiconfig.config.pdict.usageType),
          defaultValue: "qt",
        },
        orderNo:{
          type:DataTypes.INTEGER,
          allowNull: false,
          defaultValue:0
        },
    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        //freezeTableName: true,
        // define the table's name
        tableName: 'bs_areainfo',
        validate: {},
        indexes: [
            // Create a unique index on email
            //  {
            //    unique: true,
            //    fields: ['email']
            //  },
            //
            //  // Creates a gin index on data with the jsonb_path_ops operator
            //  {
            //    fields: ['data'],
            //    using: 'gin',
            //    operator: 'jsonb_path_ops'
            //  },
            //
            //  // By default index name will be [table]_[fields]
            //  // Creates a multi column partial index
            //  {
            //    name: 'public_by_author',
            //    fields: ['author', 'status'],
            //    where: {
            //      status: 'public'
            //    }
            //  },
            //
            //  // A BTREE index with a ordered field
            //  {
            //    name: 'title_index',
            //    method: 'BTREE',
            //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
            //  }
        ]
    });
}
