const system = require("../../system");
const ServiceBase = require("../sve.base");

class BankthreelogService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(BankthreelogService));
    this.utilesignbaoSve = system.getObject("service.utilesignbaoSve");
  }

  async personTwo(params) {
    params.userIdNo = params.userIdNo.toUpperCase();

    // 验证电子签
    let exists = await this.dao.findOne({
      userName: params.userName,
      userIdNo: params.userIdNo,
      result: 1,
    });
    params.use_esign = false;
    params.result = false;
    let log = await this.dao.create(params);
    if (exists) {
      log.result = 1;
      log.save();
      return system.getResult2({pass: true});
    }

    log.use_esign = 1;
    let vp = {
      name: params.userName,
      idno: params.userIdNo,
      cardno: log.id
    };
    let res = await this.utilesignbaoSve.personTwo(vp, "BankthreelogService.personTwo");
    console.log("personTwo, res-----------------------------", res);
    if (!res || res.code == -120 || res.code == -110) {
      return system.getErrResult2("二要素（姓名、身份证）验证失败");
    }
    log.result = 1;
    log.save();
    return system.getResult2({pass: true});
  }

  async bankThree(params) {
    params.userIdNo = params.userIdNo.toUpperCase();
    // 验证电子签
    let exists = await this.dao.findOne({
      userName: params.userName,
      userIdNo: params.userIdNo,
      userBankNo: params.userBankNo,
      result: 1,
    });
    params.use_esign = false;
    params.result = false;
    let log = await this.dao.create(params);
    if (exists) {
      log.result = 1;
      log.save();
      return system.getResult2({pass: true});
    }

    log.use_esign = 1;
    let vp = {
      name: params.userName,
      idno: params.userIdNo,
      cardno: params.userBankNo
    };

    let res = await this.utilesignbaoSve.bankthree(vp, "BankthreelogService.bankThree");
    console.log("personTwo, res-----------------------------", res);
    if (!res || res.code == -120 || res.code == -110) {
      return system.getErrResult2("银行卡三要素（姓名、身份证、银行卡号）验证失败");
    }
    log.result = 1;
    log.save();
    return system.getResult2({pass: true});
  }

  async bankFour(params) {
    params.userIdNo = params.userIdNo.toUpperCase();
    // 验证电子签
    let exists = await this.dao.findOne({
      userName: params.userName,
      userIdNo: params.userIdNo,
      userBankNo: params.userBankNo,
      userMobile: params.userMobile,
      result: 1,
    });
    params.use_esign = false;
    params.result = false;
    let log = await this.dao.create(params);
    if (exists) {
      log.result = 1;
      log.save();
      return system.getResult2({pass: true});
    }

    log.use_esign = 1;
    let vp = {
      name: params.userName,
      idno: params.userIdNo,
      cardno: params.userBankNo,
      mobile: params.userMobile
    };

    let res = await this.utilesignbaoSve.bankfour(vp, "BankthreelogService.bankfour");
    console.log("personTwo, res-----------------------------", res);
    if (!res || res.code == -120 || res.code == -110) {
      return system.getErrResult2("银行卡四要素（姓名、身份证、银行卡号、银行预留手机号）验证失败");
    }
    log.result = 1;
    log.save();
    return system.getResult2({pass: true});
  }
}

module.exports = BankthreelogService;
