const system=require("../../system");
const ServiceBase=require("../sve.base");
class CacheService{
  constructor(){
     this.cacheManager=system.getObject("db.cacheManager");
  }
  async buildCacheRtn(pageValues){
    var ps=pageValues.map(k=>{
      var doc = this.cacheManager.doc;
      var descTmp="";
      Object.keys(doc).forEach(d=>{
        if(k.indexOf(d)>=0){
           descTmp=doc[d];
           return false;
        }
      });
      var tmp={name:k,val:descTmp};
      return tmp;
    });
    return ps;
  }
  async findAndCountAll(obj){
    const pageNo=obj.pageInfo.pageNo;
    const pageSize=obj.pageInfo.pageSize;
    const search=obj.search;
    console.log(search);
    const limit=pageSize;
    const offset=(pageNo-1)*pageSize;
    var s="*";
    if(search && search.name && search.name!=""){
      s=s+search.name+"*";
    }
    var keys=await this.cacheManager["MagCache"].keys(s);
    var pageValues=keys.slice(offset,offset+limit);
    var kobjs = await  this.buildCacheRtn(pageValues);
    var rtnData={rows:kobjs,count:keys.length};
    return rtnData;
  }
//app调用次数
  async findAndCountAlldetail(obj){
     var apicallAccu= await this.cacheManager["ApiAccuCache"].getApiCallAccu(obj);
     var result={rows:[],count:0};
     var keys=await this.cacheManager["MagCache"].keys("api_call_" + appkey + "*");
     var detail=null;
     for(let j=0;j<keys.length;j++){
       var d=keys[j];
       var pathdetail=d.substr(d.lastIndexOf("_")+1,d.length);
       var apicalldetailAccu= await this.cacheManager["ApiCallCountCache"].getApiCallCount(appkey,pathdetail);
       var detail={"detailPath":d,"detailCount":apicalldetailAccu.callcount};
      }
     result.rows=detail;
}
  async delCache(obj){
    return this.cacheManager["MagCache"].del(obj.key);
  }
  async clearAllCache(obj){
    return this.cacheManager["MagCache"].clearAll();
  }
}
module.exports=CacheService;
