const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require("moment");

class EsettleofflinetaxService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(EsettleofflinetaxService));

    this.esettleofflineitemDao = system.getObject("db.esettleofflineitemDao");
  }

  async genByMonth(month) {
    if (!month) {
      return;
    }
    await this.dao.customExecAddOrPutSql(delSql, "DELETE FROM c_esettle_offline_tax WHERE month = " + month);

    var list = await this.customQuery("SELECT `month`, id_no, id_name, SUM(amt) AS amt, SUM(actual_amt) AS actual_amt FROM `c_esettle_offline_item` WHERE `month` = :month GROUP BY id_no", {
      month: month
    });
    if(!list || list.length == 0) {
      return;
    }

    for(var item of list) {
      var amt = item.amt;
      var actual_amt = item.actual_amt;

      // 计算个税，增值税TODO 
    }
  }

  async pageByCondition(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};

    if (params.month) {
      where.month = params.month;
    }

    if (params.id_no) {
      where.id_no = params.id_no;
    }

    if (params.id_name) {
      where.id_name = params.id_name;
    }

    var orderby = [
      ["month", 'desc']
    ];

    var attributes = ["id", "id_no", "id_name", "amt", "actual_amt", "income_tax", "service_tax", "added_value_tax"];

    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      for (var row of page.rows) {}
      system.f2y4list(page.rows, ["amt", "actual_amt", "income_tax", "service_tax", "added_value_tax"]);
    }
    return page;
  }
}
module.exports = EsettleofflinetaxService;