const system=require("../../system");
const ServiceBase=require("../sve.base");
class EtemplateService extends ServiceBase{
  constructor(){
     super(ServiceBase.getDaoName(EtemplateService));
     //this.appDao=system.getObject("db.appDao");

     this.ecompanyDao = system.getObject("db.ecompanyDao");
     this.ecompanymainDao = system.getObject("db.ecompanymainDao");
  }

  async allByEcid(ecid) {
    let all = {};
    all.template = await this.dao.findById(ecid);
    all.company = await this.ecompanyDao.findById(all.template.ecompany_id || 0);
    all.main = await this.ecompanymainDao.findById(all.template.ecompanyMainId || 0);
    return all;
  }

  async signPage(params) {
    var currentPage = Number(params.currentPage || 0);
    var pageSize = Number(params.pageSize || 10);

    var where = {};
    if (params.name) {
      where.name = {
        [this.db.Op.like]: "%" + params.name + "%"
      };
    }

    if (params.ecompany_id) {
      where.ecompany_id = params.ecompany_id;
    }

    if(params.ecompanyIds) {
      where.ecompany_id = {
        [this.db.Op.in]: params.ecompanyIds
      };
    }

    var orderby = [
      ["id", 'desc']
    ];

    var attributes = ["id", "name", "ecompanyMainId", "mainId", "nameA", "filekey", "filepath", "created_at", "updated_at", "qrcodeurl", "ecompany_id"];
    var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
    if (page && page.rows) {
      var ecompanyIds = [];
      for(var row of page.rows) {
        this.handleDate(row, ["created_at" , "updated_at"]);
      }
      await this.setCompany(page.rows);
      await this.setMain(page.rows);
    }
    return page;
  }

  async getListByName(name){
    return await this.dao.getListByName(name);
  }

  async setCompany(list) {
    if (!list || list.length == 0) {
      return;
    }

    var companyIds = [];
    for (var item of list) {
      companyIds.push(item.ecompany_id || 0);
    }
    var companyMap = await this.ecompanyDao.findMapByIds(companyIds, " id, name ");
    for (var item of list) {
      item.ecompany = companyMap["id_" + (item.ecompany_id || 0)];
    }
  }

  async setMain(list) {
    if (!list || list.length == 0) {
      return;
    }

    var ids = [];
    for (var item of list) {
      if(item.ecompanyMainId) {
        ids.push(item.ecompanyMainId);
      }
    }
    var mainMap = await this.ecompanymainDao.findMapByIds(ids);
    for (var item of list) {
      item.ecompanyMain = mainMap[item.ecompanyMainId] || {};
    }
  }

  async getInfo(id) {
    var attrs = ["id", "name", "ecompanyMainId", "mainId", "nameA", "templateid", "filekey", "filepath", "qrcodeurl", 
    "placeholderkey", "isEnabled", "created_at", "updated_at", "ecompany_id"];
    return await this.dao.model.findOne({
      where: { id: id }, attrs, raw: true
    });
  }

  async findReadyContracts(obj){
    obj.isEnabled=true;
    let sql = "SELECT t1.*, t2.id AS companyid, t2.`name` AS companyname " +
              "FROM `c_etemplate` t1 " +
              "INNER JOIN c_ecompany t2 ON t1.`ecompany_id` = t2.id " +
              "WHERE t1.isEnabled = 1 AND t1.ecompany_id = :ecompany_id " +
              "AND t1.id NOT IN  (SELECT etemplate_id FROM `c_econtract` WHERE usereaccount_id = :usereaccount_id  AND eflowstatus = '2') " +
              "AND t2.`deleted_at` IS NULL AND t1.`deleted_at` IS NULL ";

    let params = {ecompany_id:obj.ecompany_id, usereaccount_id : obj.eaccount_id};
    var list = await this.dao.customQuery(sql, params);
    if(!list || list.length == 0) {
      return [];
    }
    list.forEach(item => {
      var ecompany = {};
      ecompany.id = item.companyid;
      ecompany.name = item.companyname;
      item.ecompany = ecompany;
    });
    return list;
  }

  async findIdsByCompanyIdAndMainId(mtchId) {
    var sql = "SELECT template_id,template_type FROM `c_etemplate_busi` WHERE busi_id = :busiId";
    var list = await this.dao.customQuery(sql, {busiId: mtchId});

    var ids = {
      idsO:[],
      idsT:[],
    };
    if(list) {
      for(var item of list) {
        if(item.template_type == 1){
          ids.idsO.push(item.template_id)
        }else if(item.template_type == 2){
          ids.idsT.push(item.template_id)
        }
      }
    }
    return ids;
  }
}
module.exports=EtemplateService;
