const system = require("../../system");
const ServiceBase = require("../sve.base");
const moment = require("moment");

class LDUserService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(LDUserService));
  }
  async getById(id) {
    return await this.dao.model.findOne({where: {id: id}, raw: true});
  }
  async loginH5(params) {
    let p_id = params.p_id;
    let p_user_id = params.p_user_id;
    let p_user_balance = params.p_user_balance;
    let user = await this.dao.findOne({p_id: p_id, p_user_id: p_user_id});
    if (!user) {
      user = await this.dao.create(params);
    } else {
      user.p_user_balance = p_user_balance;
      user.save();
    }
    return user;
  }

  async updateBalance(id, balance) {
    return await this.dao.updateBalance(id, balance);
  }
}

module.exports = LDUserService;