const system = require("../system");
const qr = require("qr-image");
var settings = require("../../config/settings");
var ossClient = require("./ossClient");
const fs = require("fs");
class QrClient{
  constructor(){
    this.redisClient = system.getObject("util.redisClient");
    this.ossClient = system.getObject("util.ossClient");
  }

  /**
   * fn:生成二维码
   * @return http连接  上传失败后返回null
   * @param key
   * @returns {Promise<void>}
   */
  async generateQR(text, prev = "qc"){
    try {
      if(!text){
        return null;
      }
      let key = prev + await this.redisClient.genrateId("qrcode") + ".png";
      console.log(1, key);
      let is = qr.imageSync(text, {type: 'png' ,size :10});
      console.log(2);
      let urlRes = await this.ossClient.upfile(key, is);
      console.log(3, urlRes);
      return urlRes.url;
    }catch (e) {
      console.log(e);
      return null;
    }
  }
}
module.exports=QrClient;