var app = new Vue({
  el: "#app",
  data: function () {
    return {
      userName: "",
      mobile: "",
      city: "",
      top: 0,
      isApplying: false,
      applyStyle: "position:absolute;z-index:999;top:386px;left:33px;right:33px;text-align: center;display:none;",
      img1Style:"margin-top: 230px;width:100%;",
      img2Style:"margin-top: 20px;width:100%;",
      img3Style:"margin-top: 30px;width:100%;",
      imgWidth:"100%",
      img2Width: "100%",
      img3Width: "100%",
      checkList:[],
      a: "a"
    }
  },
  created: function () {
  },
  mounted: function () {
    $("#needh5").text("招募薪必果合伙人");
    this.calcPage();
  },
  methods: {
    postReq(path, data) {
      return axios.post(path, data).then(function (r) {
        return r.data ? r.data : null;
      })
    },
    calcPage:function() {
      var w = document.documentElement.clientWidth;
      var top = Number(w) * 386 / 360;
      var rate2 = 33 / 360;
      var lr = rate2 * w;
  
      this.applyStyle = "position:absolute;z-index:999;top:" + (top ? top : 386) + "px;left:" + lr + "px;right:" + lr + "px;text-align: center;";
  
      var rate = 340 / 360;
  
      this.imgWidth = rate * w;
      this.img2Width = this.imgWidth - 4;
      this.img3Width = this.imgWidth - 8;
      var mlr = (w - this.imgWidth) / 2;
  
      this.img1Style = "margin-top: 230px;margin-left:" + mlr + "px;";
      this.img2Style = "margin-top: 20px;margin-left:" + (mlr + 2) + "px;";
      this.img3Style = "margin-top: 30px;margin-left:" + (mlr + 4) + "px;";
  
      $("#app").css("visibility", "visible");
      console.log(w, top, this.applyStyle, this.img1Style, this.imgWidth);
  
    },
    validmethod: function (rule, value, callback) {
      console.log("code validdate");
      var self = this;
      if (rule.field == "mobile") {
        if (/^1[23456789]\d{9}$/.test(value) == false) {
          return callback(new Error("请输入正确格式的手机号"));
        }
      }
      return callback();
    },
    btnclick:function(pfm,code){
    },
    apply() {
      console.log(this.checkList);
      if (!this.userName) {
        this.$message.warning("请输入姓名");
        return false;
      }
      if (this.userName.length > 20) {
        this.$message.warning("姓名不能超过20个字");
        return false;
      }
      if (!this.mobile) {
        this.$message.warning("请输入手机号");
        return false;

      }
      if (!/^1[23456789]\d{9}$/.test(this.mobile)) {
        this.$message.warning("手机号码格式不正确");
        return false;
      }
      if (this.city.length > 20) {
        this.$message.warning("城市太长了");
        return false;
      }
      var self = this;

      var params = {
        userName: this.userName,
        mobile: this.mobile,
        city: this.city,
        advList: this.checkList
      }
      if (this.isApplying) {
        return false;
      }
      this.isApplying = true;
      this.$root.postReq("/web/epartnerCtl/apply", params).then(function (d) {
        console.log(d);
        self.isApplying = false;
        if (d.code == 0) {
          self.$message.warning("提交成功");
        } else {
          self.$message.warning(d.msg || "提交失败, 擎稍后重试");
        }
      });
    }
  },
});