var app = new Vue({
  el: "#app",
  data: function () {
    return {
      top: 0,
      updateLoading:false,
      isApplying: false,
      input5: '',
      availableAmt: 0,
      form: {
        outTradeNo:'',
        tradeTime: '',
        verifyCode: '',
        params: '',
        sign: '',
      },
      a: "a",
    }
  },
  created: function () {
  },
  mounted: function () {
    this.updateAmt();
  },
  methods: {
    postReq(path, data) {
      return axios.post(path, data).then(function (r) {
        return r.data ? r.data : null;
      })
    },
    onSign() {
      var self = this;
      if(!this.form.params || !this.form.params.trim()) {
        self.$message.warning("请填写请求参数");
        return ;
      }

      var param;
      try {
        param = JSON.parse(this.form.params);
      } catch (error) {
        self.$message.warning("请求参数JSON格式错误");
        console.error(error);
        return;
      }

      self.$root.postReq("/web/esettleCtl/getSign", param).then(function (d) {
        console.log(d);
        if (d.status == 0) {
          self.form.sign = d.data.sign;
          self.form.tradeTime = d.data.tradeTime;
          self.form.outTradeNo = d.data.outTradeNo;
          self.form.nonceStr = d.data.nonceStr;
        } else {
          self.$message.warning("签名失败");
        }
      });
    },
    onSubmit() {
      var self = this;
      if(!self.form.verifyCode || !self.form.verifyCode.trim()) {
        self.$message.warning("请填写验证码");
        return;
      }

      if(!self.form.sign || !self.form.sign.trim()) {
        self.$message.warning("请先签名");
        return;
      }

      if(!self.form.params || !self.form.params.trim()) {
        self.$message.warning("请填写请求参数");
        return;
      }

      var param;
      try {
        param = JSON.parse(this.form.params);
      } catch (error) {
        self.$message.warning("请求参数JSON格式错误");
        console.error(error);
        return;
      }

      self.$root.postReq("/web/esettleCtl/transfer", this.form).then(function (d) {
        console.log(d);
        if (d.status == 0) {
          self.$message.success("转账成功");
        } else {
        }
      });
    },

    onParamsChange() {
    },
    updateAmt() {
      this.updateLoading = true;
      var self = this;
      self.$root.postReq("/web/esettleCtl/busiAccount", this.epartner).then(function (d) {
        if (d.code == 1) {
          if(d.data && d.data.bizContent && d.data.bizContent[0]) {
            var bizc = d.data.bizContent[0];
            var amt = bizc.availableAmt || 0;
            self.availableAmt = parseFloat((amt / 100).toFixed(2));
          }

        } else {
        }
        self.updateLoading = false;
      });

      setTimeout(() => {
          self.updateLoading = false;
      }, 1000);
    },
  },
});