var app = new Vue({
  el: "#app",
  data: function () {
    return {
      isaggree: false,
      companyName: "",
      btnloading: true,
      appid:"wxf616c0a459d66081",
      isIdNameEdit: true,
      isIdNoEdit: true,
      code: "",
      state: "",
      openId: "",
      ecid:"",
      wxuser: {},
    }
  },
  created: function () {
  },
  mounted: function () {
    var self = this;
    var url = window.location.href;
    this.code = this.getUrlParam("code") || "";
    this.state = this.getUrlParam("state") || "";
    var nonceStr = this.getUrlParam("nonceStr") || "";
    var userCode = this.getUrlParam("userCode") || "";
    var sign = this.getUrlParam("sign") || "";
    this.ecid = this.getUrlParam("ecid") || this.state;
    // %E5%BC%A0%E8%A1%8C%E8%89%AF
    if(this.code) {
      if(!userCode) {
        this.wxuser.userCode = localStorage.getItem("userCode") || "";
      }

      $("#loading").fadeOut();
      // TODO 获取openId
      this.getCompany();
      this.getOpenId();
    } else {
      self.$root.postReq("/web/ecompanywxuserCtl/validateECSign", {
        ecid: self.ecid,
        nonceStr: nonceStr,
        userCode: userCode,
        sign: sign,
      }).then(rd => {
        if (rd.status == 0) {
          localStorage.removeItem("userCode");
          if(userCode) {
            localStorage.setItem("userCode", userCode);
          }

          url = url.split("?")[0];
          // url = "https://bpohhr.gongsibao.com/bpoproxy"
          // http://192.168.18.125:3000/wxsign?comid=10172&userCode=100018&nonceStr=nonceStrnonceStr&sign=E47D90EA49DCB7E9114A27767DCBF3C2
          var redirect_uri = encodeURIComponent(url);
          var appkey = this.appid;
          var wxurl = `https://open.weixin.qq.com/connect/oauth2/authorize?appid=${appkey}&redirect_uri=${redirect_uri}&response_type=code&scope=snsapi_base&state=${this.ecid}#wechat_redirect`;
          window.location.href = wxurl;
        } else {
          alert("签名失败，请关闭该页重试");
        }
      });
    }
  },

  methods: {
    postReq(path, data) {
      return axios.post(path, data).then(function (r) {
        return r.data ? r.data : null;
      })
    },
    getCompany() {
      this.$root.postReq("/web/ecompanywxuserCtl/companyByEcid", {
        ecid: this.ecid
      }).then(rd => {
        if (rd.status == 0) {
          self.companyName = (rd.data || {}).name || "";
          $("#companyTitle").text(self.companyName || "公司错误");
        } else {
          self.$message.error(`公司不存在`);
        }
      });
    },
    getOpenId() {
      var self = this;
      if(self.openId) {
        return;
      }
      //调用接口,根据用户名判断是否协议
      this.$root.postReq("/web/wxCtl/wxuseropenid", {
        code: self.code
      }).then(rd => {
        if (rd.status == 0) {
          self.openId = rd.data;
          self.btnloading = false;
        } else {
          self.$message.error(`获取openId失败，请退出重试`);
        }
      });
    },
    getUrlParam(name) {
      var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
      var r = window.location.search.substr(1).match(reg);
      return r ? unescape(r[2]) : null;
    },
    showaggreement() {
      window.location.href = "https://bpohhr.gongsibao.com/wxsignaggreement?ecid=" + this.ecid;
    },
    save() {
      var self = this;
      if(!self.openId) {
        self.$message.error(`获取openId失败，请刷新重试`);
        return;
      }
      self.btnloading = true;

      self.wxuser.openId = self.openId;
      self.wxuser.code = self.code;
      self.wxuser.etemplate_id = self.ecid;
      //处理登录逻辑
      self.$root.postReq("/web/ecompanywxuserCtl/saveEcidUser", self.wxuser).then(function(d){
        if (d.status==0) {
          self.$message.success("保存成功");
        } else {
          self.$message.warning(d.msg || "登录失败, 请稍候重试");
        }
        self.btnloading = false;
      });
    },
  },
});