var tmpl=`
    <el-button :loading="clicked" ref="" :data-val="val" @click="onclick">
            <el-row style="padding:0px;width:150px;margin-top:10px">
              <el-col :span="8">
                 <h2 class="el-icon-refresh" style="margin-top:15px"></h2>
              </el-col>
              <el-col :span="8">
                  <div>{{baoAmount}}枚宝币<div></br>
                  <div>{{val}}元人民币<div>
              </el-col>
            </el-row>
    </el-button>
`
module.exports=
`{
   template:'${tmpl}',
   model:{
    prop: 'value',
    event: 'click'
   },
   props:['value','price'],
   data:function(){
     return {
       val:this.value,
       clicked:false,
     };
   },
   watch:{
    value:function(cv){
      this.val=cv;
    }
   },
   methods:{
     onclick:function(e){
       this.$emit("click",this.val,this);
       
     }
   },
   computed:{
     baoAmount:function(){
       return Number(this.val)*Number(this.price);
     }
   },
   vname:"gsb-paybutton"
}`
