var tmpl=`
  <div v-if="visible">
    <div v-if="!isconfirm" style="border:1px solid #ccc;text-align:center;z-index:1000;background-color:white;position:fixed;bottom:0px;width:100%;height:300px">
        <div style="padding-bottom:10px;border-bottom:1px solid #eee">
          <el-button @click="close" icon="el-icon-close" type="fatal" style="float:right;margin-top:-10px;margin-right:30px" circle></el-button>
          <h3 style="color:#999;margin:30px"><i style="color:orange" class="el-icon-warning"></i>宝币余额不足，请选择充值兑换</h3>
        </div>
        <br/>  <br/>
        <el-row type="flex"  justify="space-around">
          <el-col :span="6">
              <gsb-paybutton value="1"  price="100" @click="onclick"></gsb-paybutton>
          </el-col>
          <el-col :span="6">
              <gsb-paybutton value="5" price="100" @click="onclick"></gsb-paybutton>
          </el-col>
          <el-col :span="6">
              <gsb-paybutton value="10" price="100" @click="onclick"></gsb-paybutton>
          </el-col>
          <el-col :span="6">
              <gsb-paybutton value="25" price="100" @click="onclick"></gsb-paybutton>
          </el-col>
          <el-col :span="6">
              <gsb-paybutton value="50" price="100" @click="onclick"></gsb-paybutton>
          </el-col>
        </el-row>
    </div>
    <div v-if="isconfirm" style="border:1px solid #ccc;text-align:center;z-index:1000;background-color:white;position:fixed;bottom:0px;width:100%;height:300px">
        <div style="padding-bottom:10px;border-bottom:1px solid #eee">
          <el-button @click="close" icon="el-icon-close"  style="float:right;margin-top:-10px;margin-right:30px" circle></el-button>
          <h3 style="color:#bbb;margin:30px"><i style="color:orange" class="el-icon-warning"></i>扫下方二维码，请在5分钟内完成支付兑换</h3>
        </div>
        <br/>
        <el-row  type="flex"  justify="space-around">
           <img style="width:150px;height:150px;margin-top:0px" :src="payqcurl"/>
           <el-progress color="red" style="margin-top:15px" type="circle" width="126" :percentage="progress"></el-progress>
        </el-row>
    </div>
  </div>
`
module.exports=
`{
   template:'${tmpl}',
   props:[],
   data:function(){
     return {
       visible:false,
       payqcurl:"#",
       isconfirm:false,
       clickedBtn:null,
       progress:0,

     };
   },
   methods:{
     show:function(){
       console.log("show...............");
       this.visible=true;
       this.isconfirm=false;
     },
     updateProgress:function(p){
        console.log(p);
        this.progress=p;
     },
     onclick:function(v,refbutton){
         this.clickedBtn=refbutton;
         var msg="富翁的祖先，您确认要兑换￥"+v+"元的宝币吗?";
         if(v=="50"){
           msg="富二代，嘻嘻，确认要兑换￥"+v+"元的宝币吗?";
         }
         this.$confirm(msg, '提示', {
          confirmButtonText: '确定',
          cancelButtonText: '取消',
          type: 'warning',
        }).then(() => {
           this.clickedBtn.clicked=true;
           this.$root.postReq("/web/tradeCtl/createUnifiedOrder",{amount:v,desc:"充值兑换宝币"}).then(d=>{
             this.clickedBtn.clicked=false;
             console.log(d);
             if(d.data){
               this.isconfirm=true;
               this.payqcurl=d.data.qrurl;
               localStorage["tradekey"]=d.data.tradekey+"_"+new Date().getTime();
               this.$root.checkPayState();
             }else{
               this.$message({
                 message: '兑换成功，宝币余额已经更新',
                 type: 'success'
               });
             }
           });
        }).catch(() => {
           this.isconfirm=false;
        });
     },
     close:function(){
       this.visible=false;
       this.isconfirm=false;
       this.$nextTick(()=>{
            localStorage.removeItem("tradekey");
       });
     },
   },
   vname:"gsb-payselect"
}`
