{
    template: '${tmpl}',
        data: function () {
            return {
                tms: [],
                companyresult: null,
                epartnerList:[],
                epartnerLoading: false,
                contractForm: {
                    id: 0,
                    contractNo: "",
                    remarkName: "",
                    nameUrl: "",
                    epartner_id: "",
                    nameA: "智信云（天津）科技有限公司",
                    names: [],
                },
                rules: {
                    contractNo: [
                        { required: true, message: '请输入合同编号', trigger: 'blur' }
                    ],
                    remarkName: [
                        { required: true, message: '请输入备注', trigger: 'blur' },
                        { max: 20, message: '城市备注了, 不能超过20个字', trigger: 'blur' }
                    ],
                    nameA: [
                        { required: true, message: '请输入签约主体', trigger: 'blur' }
                    ],
                },
                isloadparse: false,
                isloadsave: false
            }
        },
    mounted: function () {

    },
    created: function () {

    },
    methods: {
        parseCompany() {
            var self = this;
            if(!this.companyresult) {
                this.$message({
                    type: 'warning',
                    message:"请先上传公司名单",
                });
                return ;
            }
            self.isloadparse = true;
            this.contractForm.nameUrl = this.companyresult[0].url;

            this.$root.postReq("/web/ecompanycontractCtl/parseExcel", {
                nameUrl: self.contractForm.nameUrl
            }).then(function (d) {

                if (d.status == 0 && d.data.code == 1) {
                    self.contractForm.names = [];
                    for (i = 0, len = d.data.data.length; i < len; i++) {
                        var subname = d.data.data[i].split("-")[0];
                        var isExists = d.data.data[i].split("-")[1];
                        self.contractForm.names.push({
                            subname: subname,
                            isExists: isExists
                        });
                    }
                } else {
                    
                }
                self.isloadparse = false;

            });
        },
        getLoginUser() {
            var self = this;
            this.$root.postReq("/web/userCtl/loginUser", {}).then(function (d) {
                if (d.status == 0 && d.data) {
                    self.currentUser = d.data;
                    /*d.data.isDefaultPassword pushx*/
                    self.showPage = true;
                }
            });
        },
        gopay() {
            this.$root.pushx({
                title: "查看订单",
                name: "/ecommissionlist"
            });
        },
        saveContract(){
            var self = this;        
            if (!self.contractForm.names || self.contractForm.names.length == 0) {
                self.$message.warning("请先上传公司名单, 并解析");
                return;
            }
            this.$refs['contractForm'].validate((valid) => {
                if (valid) {
                    self.isloadsave = true;
                    self.$root.postReq("/web/ecompanycontractCtl/saveContract", {
                        contractNo: self.contractForm.contractNo, 
                        remarkName: self.contractForm.remarkName, 
                        nameUrl: self.contractForm.nameUrl,
                        names: self.contractForm.names,
                        epartner_id: self.contractForm.epartner_id,
                        nameA: self.contractForm.nameA,
                    }).then(function (d) {
                        console.info(d, "**************************************");
                        if (d.status == 0) {
                            self.$message({message: '保存成功',type: 'success'});
                            self.$refs['contractForm'].resetFields();
                        } else {
                            self.contractForm.contractNo = "";
                            self.$message.error(d.msg || "保存失败");
                        }
                        self.isloadsave = false;
                    });

                } else {
                    return false;
                }
            });
        },
        tableRowStyle({ row, rowIndex }) {
            if (row.isExists == 1) {
                return 'background-color: pink';
            }
        },
        getEPartners(query) {
            var self = this;
            self.epartnerLoading = true;
            self.$root.postReq("/web/epartnerCtl/suggest", {
                name: query
            }).then(function (d) {
                self.epartnerLoading = false;
                self.epartnerList = d.data || [];
            });
            setTimeout(() => {
                self.epartnerLoading = false; 
            }, 5000);
        },
    },
    vname: "gsb-ecompanycontract"
}